/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileSave {
    private File file = null;

    public FileSave(String title, String name) {
        this(title, name, new File(System.getProperties().getProperty("user.dir")));
    }

    public FileSave(String title, String name, File currentDirectory) {
        this(title, name, currentDirectory, 1, null, new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                return "Folder To Save In";
            }
        });
    }

    public FileSave(String title, int JFileChooserFileSelectionMode, File selectedFile, File currentDirectory) {
        this(title, null, currentDirectory, JFileChooserFileSelectionMode, selectedFile, null);
    }

    public FileSave(String title, String name, File currentDirectory, int JFileChooserFileSelectionMode, File selectedFile, FileFilter fileFilter) {
        int r;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooserFileSelectionMode);
        chooser.setDialogTitle(title);
        if (selectedFile != null) {
            chooser.setSelectedFile(selectedFile);
        }
        chooser.setCurrentDirectory(currentDirectory == null || !currentDirectory.exists() ? new File(System.getProperties().getProperty("user.dir")) : currentDirectory);
        if (fileFilter != null) {
            chooser.setFileFilter(fileFilter);
        }
        if ((r = chooser.showSaveDialog(null)) == 0) {
            this.file = name != null ? new File(chooser.getSelectedFile().getPath() + File.separator + name) : new File(chooser.getSelectedFile().getPath());
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getPathString() {
        if (this.file == null) {
            return null;
        }
        return this.file.getPath();
    }
}

