/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import util.image.FileOpen;

public class ImageShrinker {
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";

    public static void main(String[] args) throws Exception {
        ImageShrinker.handleCommandLineArgs(args);
        JOptionPane.showMessageDialog(null, new JLabel("<html>This is the ImageShrinker, it will create a smallMap.jpeg file for you. <br>Put in your base map or relief map, and it will spit out a small scaled copy of it.<br>Please note that the quality of the image will be worse than if you use a real painting program.<br>So we suggest you instead shrink the image with paint.net or photoshop or gimp, etc, then clean it up before saving.</html>"));
        File mapFile = new FileOpen("Select The Large Image", s_mapFolderLocation, ".gif", ".png").getFile();
        if (mapFile == null || !mapFile.exists()) {
            throw new IllegalStateException(mapFile + "File does not exist");
        }
        if (s_mapFolderLocation == null) {
            s_mapFolderLocation = mapFile.getParentFile();
        }
        String input = JOptionPane.showInputDialog(null, (Object)"Select scale");
        float scale = Float.parseFloat(input);
        BufferedImage baseImg = ImageIO.read(mapFile);
        int thumbWidth = (int)((float)((Image)baseImg).getWidth(null) * scale);
        int thumbHeight = (int)((float)((Image)baseImg).getHeight(null) * scale);
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(baseImg, 0, 0, thumbWidth, thumbHeight, null);
        File file = new File(new File(mapFile.getPath()).getParent() + File.separatorChar + "smallMap.jpeg");
        FileImageOutputStream out = new FileImageOutputStream(file);
        ImageWriter encoder = ImageIO.getImageWritersByFormatName("JPEG").next();
        JPEGImageWriteParam param = new JPEGImageWriteParam(null);
        param.setCompressionMode(2);
        param.setCompressionQuality(1.0f);
        encoder.setOutput(out);
        encoder.write(null, new IIOImage(thumbImage, null, null), param);
        out.close();
        System.out.println("Image successfully written to " + file.getPath());
        System.exit(0);
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        File mapFolder;
        String value;
        if (args.length == 1) {
            value = args[0].startsWith(TRIPLEA_MAP_FOLDER) ? ImageShrinker.getValue(args[0]) : args[0];
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        } else if (args.length > 1) {
            System.out.println("Only argument allowed is the map directory.");
        }
        if ((s_mapFolderLocation == null || s_mapFolderLocation.length() < 1L) && (value = System.getProperty(TRIPLEA_MAP_FOLDER)) != null && value.length() > 0) {
            mapFolder = new File(value = value.replaceAll("\\(", " "));
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
    }
}

