/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.data.properties.BooleanProperty;
import games.strategy.engine.data.properties.CollectionProperty;
import games.strategy.engine.data.properties.ColorProperty;
import games.strategy.engine.data.properties.ComboProperty;
import games.strategy.engine.data.properties.DoubleProperty;
import games.strategy.engine.data.properties.FileProperty;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.data.properties.MapProperty;
import games.strategy.engine.data.properties.NumberProperty;
import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.engine.data.properties.StringProperty;
import games.strategy.util.PropertyUtil;
import games.strategy.util.Tuple;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import util.image.MapProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPropertyWrapper<T>
extends AEditableProperty {
    private static final long serialVersionUID = 6406798101396215624L;
    private IEditableProperty m_property;
    private final Method m_setter;
    private final Method m_getter;

    public MapPropertyWrapper(String name, String description, T defaultValue, Method setter, Method getter) {
        super(name, description);
        this.m_setter = setter;
        this.m_getter = getter;
        if (defaultValue instanceof Boolean) {
            this.m_property = new BooleanProperty(name, description, (Boolean)defaultValue);
        } else if (defaultValue instanceof Color) {
            this.m_property = new ColorProperty(name, description, (Color)defaultValue);
        } else if (defaultValue instanceof File) {
            this.m_property = new FileProperty(name, description, (File)defaultValue);
        } else if (defaultValue instanceof String) {
            this.m_property = new StringProperty(name, description, (String)defaultValue);
        } else if (defaultValue instanceof Collection || defaultValue instanceof List || defaultValue instanceof Set) {
            this.m_property = new CollectionProperty(name, description, (Collection)defaultValue);
        } else if (defaultValue instanceof Map || defaultValue instanceof HashMap) {
            this.m_property = new MapProperty(name, description, (Map)defaultValue);
        } else if (defaultValue instanceof Integer) {
            this.m_property = new NumberProperty(name, description, Integer.MAX_VALUE, Integer.MIN_VALUE, (Integer)defaultValue);
        } else if (defaultValue instanceof Double) {
            this.m_property = new DoubleProperty(name, description, Double.MAX_VALUE, Double.MIN_VALUE, (Double)defaultValue, 5);
        } else {
            throw new IllegalArgumentException("Can not instantiate PropertyWrapper with: " + defaultValue.getClass().getCanonicalName());
        }
    }

    public MapPropertyWrapper(String name, String description, T defaultValue, Collection<T> possibleValues, Method setter, Method getter) {
        super(name, description);
        this.m_setter = setter;
        this.m_getter = getter;
        if (!(defaultValue instanceof Collection)) {
            throw new IllegalArgumentException("Can not instantiate PropertyWrapper with: " + defaultValue.getClass().getCanonicalName());
        }
        this.m_property = new ComboProperty<T>(name, description, defaultValue, possibleValues);
    }

    public MapPropertyWrapper(String name, String description, int max, int min, int defaultValue, Method setter, Method getter) {
        super(name, description);
        this.m_setter = setter;
        this.m_getter = getter;
        this.m_property = new NumberProperty(name, description, max, min, defaultValue);
    }

    public MapPropertyWrapper(String name, String description, double max, double min, double defaultValue, int places, Method setter, Method getter) {
        super(name, description);
        this.m_setter = setter;
        this.m_getter = getter;
        this.m_property = new DoubleProperty(name, description, max, min, defaultValue, places);
    }

    public MapPropertyWrapper(String name, String description, File defaultValue, String[] acceptableSuffixes, Method setter, Method getter) {
        super(name, description);
        this.m_setter = setter;
        this.m_getter = getter;
        this.m_property = new FileProperty(name, description, defaultValue, acceptableSuffixes);
    }

    @Override
    public int getRowsNeeded() {
        return this.m_property.getRowsNeeded();
    }

    @Override
    public Object getValue() {
        return this.m_property.getValue();
    }

    public T getValueT() {
        return (T)this.m_property.getValue();
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        this.m_property.setValue(value);
    }

    public void setValueT(T value) {
        this.m_property.setValue(value);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.m_property.getEditorComponent();
    }

    public T getFromObject(Object object) {
        try {
            return (T)this.m_getter.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setToObject(Object object) {
        Object value = this.getValue();
        Object[] args = new Object[]{value};
        try {
            System.out.println(this.m_setter + "   to   " + value);
            this.m_setter.invoke(object, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static List<MapPropertyWrapper> createProperties(Object object) {
        ArrayList<MapPropertyWrapper> properties = new ArrayList<MapPropertyWrapper>();
        for (Method setter : object.getClass().getMethods()) {
            Object currentValue;
            Method getter;
            boolean startsWithSet = setter.getName().startsWith("set");
            if (!startsWithSet) continue;
            String propertyName = setter.getName().substring(Math.min(3, setter.getName().length()), setter.getName().length());
            try {
                getter = object.getClass().getMethod("get" + propertyName, new Class[0]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            Field field = PropertyUtil.getFieldIncludingFromSuperClasses(object.getClass(), propertyName, false);
            try {
                currentValue = field.get(object);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            try {
                MapPropertyWrapper<Object> wrapper = new MapPropertyWrapper<Object>(propertyName, null, currentValue, setter, getter);
                properties.add(wrapper);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    public static void writePropertiesToObject(Object object, List<MapPropertyWrapper> properties) {
        for (MapPropertyWrapper p : properties) {
            p.setToObject(object);
        }
    }

    public static PropertiesUI createPropertiesUI(List<? extends IEditableProperty> properties, boolean editable) {
        return new PropertiesUI(properties, editable);
    }

    public static Tuple<PropertiesUI, List<MapPropertyWrapper>> createPropertiesUI(Object object, boolean editable) {
        List<MapPropertyWrapper> properties = MapPropertyWrapper.createProperties(object);
        PropertiesUI ui = new PropertiesUI(properties, editable);
        return new Tuple<PropertiesUI, List<MapPropertyWrapper>>(ui, properties);
    }

    @Override
    public boolean validate(Object value) {
        return this.m_property.validate(value);
    }

    public static void main(String[] args) {
        MapProperties mapProperties = new MapProperties();
        List<MapPropertyWrapper> properties = MapPropertyWrapper.createProperties(mapProperties);
        PropertiesUI ui = MapPropertyWrapper.createPropertiesUI(properties, true);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(ui);
        frame.pack();
        frame.setVisible(true);
    }
}

