/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.ui.Util;
import games.strategy.util.PointFileReaderWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import util.image.FileOpen;
import util.image.FileSave;

public class PlacementPicker
extends JFrame {
    private static final long serialVersionUID = 953019978051420881L;
    private final JCheckBoxMenuItem showAllModeItem;
    private final JCheckBoxMenuItem showOverflowModeItem;
    private final JCheckBoxMenuItem showIncompleteModeItem;
    private static boolean s_showAllMode = false;
    private static boolean s_showOverflowMode = false;
    private static boolean s_showIncompleteMode = false;
    private static int s_incompleteNum = 1;
    private Point m_currentSquare;
    private Image m_image;
    private final JLabel m_location;
    private Map<String, List<Polygon>> m_polygons;
    private Map<String, List<Point>> m_placements;
    private List<Point> m_currentPlacements;
    private String m_currentCountry;
    private static int PLACEWIDTH = 48;
    private static int PLACEHEIGHT = 48;
    private static boolean placeDimensionsSet = false;
    private static double unit_zoom_percent = 1.0;
    private static int unit_width = 48;
    private static int unit_height = 48;
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private static final String TRIPLEA_UNIT_ZOOM = "triplea.unit.zoom";
    private static final String TRIPLEA_UNIT_WIDTH = "triplea.unit.width";
    private static final String TRIPLEA_UNIT_HEIGHT = "triplea.unit.height";

    public static String[] getProperties() {
        return new String[]{TRIPLEA_MAP_FOLDER, TRIPLEA_UNIT_ZOOM, TRIPLEA_UNIT_WIDTH, TRIPLEA_UNIT_HEIGHT};
    }

    public static void main(String[] args) {
        PlacementPicker.handleCommandLineArgs(args);
        JOptionPane.showMessageDialog(null, new JLabel("<html>This is the PlacementPicker, it will create a place.txt file for you. <br>In order to run this, you must already have created a centers.txt file and a polygons.txt file. <br><br>The program will ask for unit scale (unit zoom) level [normally between 0.5 and 1.0], <br>Then it will ask for the unit image size when not zoomed [normally 48x48]. <br><br>If you want to have less, or more, room around the edges of your units, you can change the unit size. <br><br>After it starts, you may Load an existing place.txt file, that way you can make changes to it then save it. <br><br>LEFT CLICK = Select a new territory. <br><br>Holding CTRL/SHIFT + LEFT CLICK = Create a new placement for that territory. <br><br>RIGHT CLICK = Remove last placement for that territory. <br><br>Holding CTRL/SHIFT + RIGHT CLICK = Save all placements for that territory. <br><br>It is a very good idea to check each territory using the PlacementPicker after running the AutoPlacementFinder <br>to make sure there are enough placements for each territory. If not, you can always add more then save it. <br><br>IF there are not enough placements, the units will Overflow to the RIGHT of the very LAST placement made, <br>so be sure that the last placement is on the right side of the territory <br>or that it does not overflow directly on top of other placements. <br><br>To show all placements, or see the overflow direction, or see which territories you have not yet completed enough, <br>placements for, turn on the mode options in the 'edit' menu. </html>"));
        System.out.println("Select the map");
        FileOpen mapSelection = new FileOpen("Select The Map", s_mapFolderLocation, ".gif", ".png");
        String mapName = mapSelection.getPathString();
        if (s_mapFolderLocation == null && mapSelection.getFile() != null) {
            s_mapFolderLocation = mapSelection.getFile().getParentFile();
        }
        if (mapName != null) {
            PlacementPicker picker = new PlacementPicker(mapName);
            picker.setSize(800, 600);
            picker.setLocationRelativeTo(null);
            picker.setVisible(true);
        } else {
            System.out.println("No Image Map Selected. Shutting down.");
            System.exit(0);
        }
    }

    public PlacementPicker(String mapName) {
        File file;
        block36: {
            super("Placement Picker");
            this.m_location = new JLabel();
            this.m_polygons = new HashMap<String, List<Polygon>>();
            this.setDefaultCloseOperation(3);
            if (!placeDimensionsSet) {
                try {
                    int result;
                    file = null;
                    if (s_mapFolderLocation != null && s_mapFolderLocation.exists()) {
                        file = new File(s_mapFolderLocation, "map.properties");
                    }
                    if (file == null || !file.exists()) {
                        file = new File(new File(mapName).getParent() + File.separator + "map.properties");
                    }
                    if (!file.exists()) break block36;
                    double scale = unit_zoom_percent;
                    int width = unit_width;
                    int height = unit_height;
                    boolean found = false;
                    String scaleProperty = "units.scale=";
                    String widthProperty = "units.width=";
                    String heightProperty = "units.height=";
                    FileReader reader = new FileReader(file);
                    LineNumberReader reader2 = new LineNumberReader(reader);
                    int i = 0;
                    while (true) {
                        reader2.setLineNumber(i);
                        String line = reader2.readLine();
                        if (line == null) break;
                        if (line.contains("units.scale=")) {
                            try {
                                scale = Double.parseDouble(line.substring(line.indexOf("units.scale=") + "units.scale=".length()).trim());
                                found = true;
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                        if (line.contains("units.width=")) {
                            try {
                                width = Integer.parseInt(line.substring(line.indexOf("units.width=") + "units.width=".length()).trim());
                                found = true;
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                        if (!line.contains("units.height=")) continue;
                        try {
                            height = Integer.parseInt(line.substring(line.indexOf("units.height=") + "units.height=".length()).trim());
                            found = true;
                        }
                        catch (NumberFormatException ex) {}
                    }
                    reader2.close();
                    ++i;
                    if (found && (result = JOptionPane.showConfirmDialog(new JPanel(), "A map.properties file was found in the map's folder, \r\n do you want to use the file to supply the info for the placement box size? \r\n Zoom = " + scale + ",  Width = " + width + ",  Height = " + height + ",    Result = (" + (int)(scale * (double)width) + "x" + (int)(scale * (double)height) + ")", "File Suggestion", 1)) == 0) {
                        unit_zoom_percent = scale;
                        PLACEWIDTH = (int)(unit_zoom_percent * (double)width);
                        PLACEHEIGHT = (int)(unit_zoom_percent * (double)height);
                        placeDimensionsSet = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (!placeDimensionsSet || JOptionPane.showConfirmDialog(new JPanel(), "Placement Box Size already set (" + PLACEWIDTH + "x" + PLACEHEIGHT + "), " + "do you wish to continue with this?\r\nSelect Yes to continue, Select No to override and change the size.", "Placement Box Size", 0) == 1) {
            try {
                String height;
                String result = PlacementPicker.getUnitsScale();
                try {
                    unit_zoom_percent = Double.parseDouble(result.toLowerCase());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                String width = JOptionPane.showInputDialog(null, (Object)"Enter the unit's image width in pixels (unscaled / without zoom).\r\n(e.g. 48)");
                if (width != null) {
                    try {
                        PLACEWIDTH = (int)(unit_zoom_percent * (double)Integer.parseInt(width));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if ((height = JOptionPane.showInputDialog(null, (Object)"Enter the unit's image height in pixels (unscaled / without zoom).\r\n(e.g. 48)")) != null) {
                    try {
                        PLACEHEIGHT = (int)(unit_zoom_percent * (double)Integer.parseInt(height));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        file = null;
        if (s_mapFolderLocation != null && s_mapFolderLocation.exists()) {
            file = new File(s_mapFolderLocation, "polygons.txt");
        }
        if (file == null || !file.exists()) {
            file = new File(new File(mapName).getParent() + File.separator + "polygons.txt");
        }
        if (file.exists() && JOptionPane.showConfirmDialog(new JPanel(), "A polygons.txt file was found in the map's folder, do you want to use the file to supply the territories?", "File Suggestion", 1) == 0) {
            try {
                System.out.println("Polygons : " + file.getPath());
                this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(file.getPath()));
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        } else {
            try {
                System.out.println("Select the Polygons file");
                String polyPath = new FileOpen("Select A Polygon File", s_mapFolderLocation, ".txt").getPathString();
                if (polyPath != null) {
                    System.out.println("Polygons : " + polyPath);
                    this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(polyPath));
                } else {
                    System.out.println("Polygons file not given. Will run regardless");
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
        this.createImage(mapName);
        JPanel imagePanel = this.createMainPanel();
        imagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                PlacementPicker.this.m_location.setText("x:" + e.getX() + " y:" + e.getY());
                PlacementPicker.this.m_currentSquare = new Point(e.getPoint());
                PlacementPicker.this.repaint();
            }
        });
        imagePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PlacementPicker.this.mouseEvent(e.getPoint(), e.isControlDown() || e.isShiftDown(), SwingUtilities.isRightMouseButton(e));
            }
        });
        imagePanel.setMinimumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setPreferredSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setMaximumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(imagePanel), "Center");
        this.getContentPane().add((Component)this.m_location, "South");
        AbstractAction openAction = new AbstractAction("Load Placements"){
            private static final long serialVersionUID = -2894085191455411106L;

            public void actionPerformed(ActionEvent event) {
                PlacementPicker.this.loadPlacements();
            }
        };
        openAction.putValue("ShortDescription", "Load An Existing Placement File");
        AbstractAction saveAction = new AbstractAction("Save Placements"){
            private static final long serialVersionUID = -3341738809601318716L;

            public void actionPerformed(ActionEvent event) {
                PlacementPicker.this.savePlacements();
            }
        };
        saveAction.putValue("ShortDescription", "Save The Placements To File");
        AbstractAction exitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = -9093426903644867897L;

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        JMenuItem openItem = new JMenuItem(openAction);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem saveItem = new JMenuItem(saveAction);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem exitItem = new JMenuItem(exitAction);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        s_showAllMode = false;
        s_showOverflowMode = false;
        s_showIncompleteMode = false;
        s_incompleteNum = 1;
        this.showAllModeItem = new JCheckBoxMenuItem("Show All Placements Mode", false);
        this.showAllModeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                s_showAllMode = PlacementPicker.this.showAllModeItem.getState();
                PlacementPicker.this.repaint();
            }
        });
        this.showOverflowModeItem = new JCheckBoxMenuItem("Show Overflow Mode", false);
        this.showOverflowModeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                s_showOverflowMode = PlacementPicker.this.showOverflowModeItem.getState();
                PlacementPicker.this.repaint();
            }
        });
        this.showIncompleteModeItem = new JCheckBoxMenuItem("Show Incomplete Placements Mode", false);
        this.showIncompleteModeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (PlacementPicker.this.showIncompleteModeItem.getState()) {
                    String num = JOptionPane.showInputDialog(null, (Object)"Enter the minimum number of placements each territory must have.\r\n(examples: 1, 4, etc.)");
                    try {
                        s_incompleteNum = Math.max(1, Math.min(50, Integer.parseInt(num)));
                    }
                    catch (Exception ex) {
                        s_incompleteNum = 1;
                    }
                }
                s_showIncompleteMode = PlacementPicker.this.showIncompleteModeItem.getState();
                PlacementPicker.this.repaint();
            }
        });
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        editMenu.add(this.showAllModeItem);
        editMenu.add(this.showOverflowModeItem);
        editMenu.add(this.showIncompleteModeItem);
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
    }

    private void createImage(String mapName) {
        this.m_image = Toolkit.getDefaultToolkit().createImage(mapName);
        try {
            Util.ensureImageLoaded(this.m_image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = new JPanel(){
            private static final long serialVersionUID = -3941975573431195136L;

            public void paint(Graphics g) {
                g.drawImage(PlacementPicker.this.m_image, 0, 0, this);
                if (s_showAllMode) {
                    g.setColor(Color.yellow);
                    for (Map.Entry entry : PlacementPicker.this.m_placements.entrySet()) {
                        if (((String)entry.getKey()).equals(PlacementPicker.this.m_currentCountry) && PlacementPicker.this.m_currentPlacements != null && !PlacementPicker.this.m_currentPlacements.isEmpty()) continue;
                        Iterator pointIter = ((List)entry.getValue()).iterator();
                        while (pointIter.hasNext()) {
                            Point item = (Point)pointIter.next();
                            g.fillRect(item.x, item.y, PLACEWIDTH, PLACEHEIGHT);
                            if (!s_showOverflowMode || pointIter.hasNext()) continue;
                            g.setColor(Color.gray);
                            g.fillRect(item.x + PLACEWIDTH, item.y + PLACEHEIGHT / 2, PLACEWIDTH, 4);
                            g.setColor(Color.yellow);
                        }
                    }
                }
                if (s_showIncompleteMode) {
                    g.setColor(Color.green);
                    HashSet territories = new HashSet(PlacementPicker.this.m_polygons.keySet());
                    Iterator terrIter = territories.iterator();
                    while (terrIter.hasNext()) {
                        String terr = (String)terrIter.next();
                        List points = (List)PlacementPicker.this.m_placements.get(terr);
                        if (points == null || points.size() < s_incompleteNum) continue;
                        terrIter.remove();
                    }
                    for (String terr : territories) {
                        List polys = (List)PlacementPicker.this.m_polygons.get(terr);
                        if (polys == null || polys.isEmpty()) continue;
                        for (Polygon poly : polys) {
                            g.fillPolygon(poly);
                        }
                    }
                }
                g.setColor(Color.red);
                if (PlacementPicker.this.m_currentSquare != null) {
                    g.drawRect(((PlacementPicker)PlacementPicker.this).m_currentSquare.x, ((PlacementPicker)PlacementPicker.this).m_currentSquare.y, PLACEWIDTH, PLACEHEIGHT);
                }
                if (PlacementPicker.this.m_currentPlacements == null) {
                    return;
                }
                Iterator pointIter = PlacementPicker.this.m_currentPlacements.iterator();
                while (pointIter.hasNext()) {
                    Point item = (Point)pointIter.next();
                    g.fillRect(item.x, item.y, PLACEWIDTH, PLACEHEIGHT);
                    if (!s_showOverflowMode || pointIter.hasNext()) continue;
                    g.setColor(Color.gray);
                    g.fillRect(item.x + PLACEWIDTH, item.y + PLACEHEIGHT / 2, PLACEWIDTH, 4);
                    g.setColor(Color.red);
                }
            }
        };
        return imagePanel;
    }

    private void savePlacements() {
        try {
            String fileName = new FileSave("Where To Save place.txt ?", "place.txt", s_mapFolderLocation).getPathString();
            if (fileName == null) {
                return;
            }
            FileOutputStream out = new FileOutputStream(fileName);
            PointFileReaderWriter.writeOneToMany(out, this.m_placements);
            out.flush();
            out.close();
            System.out.println("Data written to :" + new File(fileName).getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadPlacements() {
        try {
            System.out.println("Load a placement file");
            String placeName = new FileOpen("Load A Placement File", s_mapFolderLocation, ".txt").getPathString();
            if (placeName == null) {
                return;
            }
            FileInputStream in = new FileInputStream(placeName);
            this.m_placements = PointFileReaderWriter.readOneToMany(in);
            this.repaint();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
    }

    private String findTerritoryName(Point p) {
        String seaName = "there be dragons";
        for (String name : this.m_polygons.keySet()) {
            Collection polygons = this.m_polygons.get(name);
            for (Polygon poly : polygons) {
                if (!poly.contains(p)) continue;
                if (name.endsWith("Sea Zone") || name.startsWith("Sea Zone")) {
                    seaName = name;
                    continue;
                }
                return name;
            }
        }
        return seaName;
    }

    private void mouseEvent(Point point, boolean ctrlDown, boolean rightMouse) {
        if (!rightMouse && !ctrlDown) {
            this.m_currentCountry = this.findTerritoryName(point);
            this.m_currentPlacements = this.m_placements == null || this.m_placements.get(this.m_currentCountry) == null ? new ArrayList<Point>() : new ArrayList<Point>((Collection)this.m_placements.get(this.m_currentCountry));
            JOptionPane.showMessageDialog(this, this.m_currentCountry);
        } else if (!rightMouse && ctrlDown) {
            if (this.m_currentPlacements != null) {
                this.m_currentPlacements.add(point);
            }
        } else if (rightMouse && ctrlDown) {
            if (this.m_currentPlacements != null) {
                if (this.m_placements == null) {
                    this.m_placements = new HashMap<String, List<Point>>();
                }
                this.m_placements.put(this.m_currentCountry, this.m_currentPlacements);
                this.m_currentPlacements = new ArrayList<Point>();
                System.out.println("done:" + this.m_currentCountry);
            }
        } else if (rightMouse && this.m_currentPlacements != null && !this.m_currentPlacements.isEmpty()) {
            this.m_currentPlacements.remove(this.m_currentPlacements.size() - 1);
        }
        this.repaint();
    }

    private static String getUnitsScale() {
        String unitsScale = JOptionPane.showInputDialog(null, (Object)"Enter the unit's scale (zoom).\r\n(e.g. 1.25, 1, 0.875, 0.8333, 0.75, 0.6666, 0.5625, 0.5)");
        if (unitsScale != null) {
            return unitsScale;
        }
        return "1";
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        String heightString;
        String widthString;
        String zoomString;
        String[] properties = PlacementPicker.getProperties();
        if (args.length == 1) {
            String value = args[0].startsWith(TRIPLEA_UNIT_ZOOM) ? PlacementPicker.getValue(args[0]) : args[0];
            try {
                Double.parseDouble(value);
                System.setProperty(TRIPLEA_UNIT_ZOOM, value);
            }
            catch (Exception ex) {}
        } else if (args.length == 2) {
            String value0 = args[0].startsWith(TRIPLEA_UNIT_WIDTH) ? PlacementPicker.getValue(args[0]) : args[0];
            try {
                Integer.parseInt(value0);
                System.setProperty(TRIPLEA_UNIT_WIDTH, value0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String value1 = args[0].startsWith(TRIPLEA_UNIT_HEIGHT) ? PlacementPicker.getValue(args[1]) : args[1];
            try {
                Integer.parseInt(value1);
                System.setProperty(TRIPLEA_UNIT_HEIGHT, value1);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean usagePrinted = false;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            boolean found = false;
            String arg = args[argIndex];
            int indexOf = arg.indexOf(61);
            if (indexOf > 0) {
                arg = arg.substring(0, indexOf);
                for (int propIndex = 0; propIndex < properties.length; ++propIndex) {
                    if (!arg.equals(properties[propIndex])) continue;
                    String value = PlacementPicker.getValue(args[argIndex]);
                    System.getProperties().setProperty(properties[propIndex], value);
                    System.out.println(properties[propIndex] + ":" + value);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            System.out.println("Unrecogized:" + args[argIndex]);
            if (usagePrinted) continue;
            usagePrinted = true;
            System.out.println("Arguments\r\n   triplea.map.folder=<FILE_PATH>\r\n   triplea.unit.zoom=<UNIT_ZOOM_LEVEL>\r\n   triplea.unit.width=<UNIT_WIDTH>\r\n   triplea.unit.height=<UNIT_HEIGHT>\r\n");
        }
        String folderString = System.getProperty(TRIPLEA_MAP_FOLDER);
        if (folderString != null && folderString.length() > 0) {
            File mapFolder = new File(folderString = folderString.replaceAll("\\(", " "));
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + folderString);
            }
        }
        if ((zoomString = System.getProperty(TRIPLEA_UNIT_ZOOM)) != null && zoomString.length() > 0) {
            try {
                unit_zoom_percent = Double.parseDouble(zoomString);
                System.out.println("Unit Zoom Percent to use: " + unit_zoom_percent);
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                System.err.println("Not a decimal percentage: " + zoomString);
            }
        }
        if ((widthString = System.getProperty(TRIPLEA_UNIT_WIDTH)) != null && widthString.length() > 0) {
            try {
                unit_width = Integer.parseInt(widthString);
                System.out.println("Unit Width to use: " + unit_width);
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + widthString);
            }
        }
        if ((heightString = System.getProperty(TRIPLEA_UNIT_HEIGHT)) != null && heightString.length() > 0) {
            try {
                unit_height = Integer.parseInt(heightString);
                System.out.println("Unit Height to use: " + unit_height);
                placeDimensionsSet = true;
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + heightString);
            }
        }
        if (placeDimensionsSet) {
            PLACEWIDTH = (int)(unit_zoom_percent * (double)unit_width);
            PLACEHEIGHT = (int)(unit_zoom_percent * (double)unit_height);
            System.out.println("Place Dimensions to use: " + PLACEWIDTH + "x" + PLACEHEIGHT);
        }
    }
}

