/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.delegate;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.delegate.SlidingTilesEndTurnExtendedDelegateState;
import games.puzzle.slidingtiles.ui.display.INPuzzleDisplay;
import games.strategy.common.delegate.BaseDelegate;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndTurnDelegate
extends BaseDelegate {
    private CountDownLatch m_waiting;

    @Override
    public void start(IDelegateBridge bridge) {
        super.start(bridge);
        if (this.gameOver(this.getData().getMap())) {
            this.signalGameOver("Board solved!");
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.m_waiting == null) {
            return;
        }
        while (this.m_waiting.getCount() > 0L) {
            this.m_waiting.countDown();
        }
    }

    @Override
    public Serializable saveState() {
        SlidingTilesEndTurnExtendedDelegateState state = new SlidingTilesEndTurnExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        SlidingTilesEndTurnExtendedDelegateState s = (SlidingTilesEndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean gameOver(GameMap map) {
        int width = map.getXDimension();
        int height = map.getYDimension();
        int previous = -2147483647;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Territory t;
                if ((t = map.getTerritoryFromCoordinates(x++, y)) == null) return false;
                Tile tile = (Tile)t.getAttachment("tile");
                if (tile == null) return false;
                int current = tile.getValue();
                if (current <= previous) {
                    return false;
                }
                previous = current;
            }
        }
        return true;
    }

    private void signalGameOver(String status) {
        INPuzzleDisplay display = (INPuzzleDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
        display.setGameOver();
        this.m_bridge.stopGameSequence();
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return null;
    }
}

