/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.ui;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.ui.BoardData;
import games.puzzle.slidingtiles.ui.PlayData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class BoardPanel
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = 981372652838512191L;
    private final BoardData m_mapData;
    private Territory m_clickedAt = null;
    private Territory m_releasedAt = null;
    private CountDownLatch m_waiting = null;
    private BufferedImage m_image;

    public BoardPanel(BoardData mapData, File file) {
        this.m_mapData = mapData;
        Dimension mapDimension = this.m_mapData.getMapDimensions();
        this.setMinimumSize(mapDimension);
        this.setPreferredSize(mapDimension);
        this.setSize(mapDimension);
        this.addMouseListener(this);
        this.setOpaque(true);
        if (file != null) {
            try {
                BufferedImage bigimage = ImageIO.read(file);
                AffineTransform trans = new AffineTransform();
                double scalex = mapDimension.getWidth() / (double)bigimage.getWidth();
                double scaley = mapDimension.getHeight() / (double)bigimage.getHeight();
                trans.scale(scalex, scaley);
                AffineTransformOp scale = new AffineTransformOp(trans, 1);
                this.m_image = new BufferedImage((int)mapDimension.getWidth(), (int)mapDimension.getHeight(), bigimage.getType());
                scale.filter(bigimage, this.m_image);
            }
            catch (IOException e) {
                this.m_image = null;
            }
        } else {
            this.m_image = null;
        }
    }

    public Dimension getMapDimensions() {
        return this.m_mapData.getMapDimensions();
    }

    protected void performPlay() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BoardPanel.this.repaint();
            }
        });
    }

    protected void paintComponent(Graphics g) {
        g.setColor(Color.white);
        Dimension mapDimension = this.m_mapData.getMapDimensions();
        g.fillRect(0, 0, mapDimension.width, mapDimension.height);
        for (Map.Entry<Territory, Polygon> entry : this.m_mapData.getPolygons().entrySet()) {
            int value;
            Polygon p = entry.getValue();
            Territory at = entry.getKey();
            Tile tile = (Tile)at.getAttachment("tile");
            if (tile != null && (value = tile.getValue()) != 0) {
                Rectangle square = p.getBounds();
                Rectangle tileData = this.m_mapData.getLocation(value);
                if (this.m_image == null) {
                    g.setColor(Color.black);
                    g.drawString(Integer.toString(value), square.x + square.width * 5 / 12, square.y + square.height * 7 / 12);
                } else if (tileData != null) {
                    g.drawImage(this.m_image, square.x, square.y, square.x + square.width, square.y + square.height, tileData.x, tileData.y, tileData.x + tileData.width, tileData.y + tileData.height, this);
                } else {
                    g.setColor(Color.white);
                    g.fillRect(square.x, square.y, square.width, square.height);
                }
            }
            g.setColor(Color.black);
            g.drawPolygon(p);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.m_clickedAt = this.m_mapData.getTerritoryAt(e.getX(), e.getY());
    }

    public void mouseReleased(MouseEvent e) {
        this.m_releasedAt = this.m_mapData.getTerritoryAt(e.getX(), e.getY());
        if (this.m_waiting != null) {
            this.m_waiting.countDown();
        }
    }

    public PlayData waitForPlay(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        this.m_waiting = waiting;
        this.m_waiting.await();
        if (this.m_clickedAt == null || this.m_releasedAt == null) {
            this.m_clickedAt = null;
            this.m_releasedAt = null;
            throw new InterruptedException("Interrupted while waiting for play.");
        }
        PlayData play = new PlayData(this.m_clickedAt, this.m_releasedAt);
        this.m_clickedAt = null;
        this.m_releasedAt = null;
        return play;
    }
}

