/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.image;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.framework.GameRunner;
import games.strategy.triplea.ResourceLoader;
import games.strategy.ui.Util;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class UnitImageFactory {
    private static final File BASE_FOLDER = new File(GameRunner.getRootFolder(), ResourceLoader.RESOURCE_FOLDER + "/units/");
    private final Map<String, Image> m_images = new HashMap<String, Image>();

    public Image getImage(UnitType type, PlayerID player, GameData data) {
        String baseName = this.getBaseImageName(type, player, data);
        String fullName = baseName + player.getName();
        if (this.m_images.containsKey(fullName)) {
            return this.m_images.get(fullName);
        }
        BufferedImage baseImage = this.getBaseImage(baseName, player);
        this.m_images.put(fullName, baseImage);
        return baseImage;
    }

    private BufferedImage getBaseImage(String baseImageName, PlayerID id) {
        String fileName = id.getName() + File.separator + baseImageName + ".png";
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(BASE_FOLDER, fileName));
            Util.ensureImageLoaded(image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    private String getBaseImageName(UnitType type, PlayerID id, GameData data) {
        StringBuilder name = new StringBuilder(32);
        name.append(type.getName());
        return name.toString();
    }
}

