/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerManager;
import games.strategy.engine.framework.IGame;
import games.strategy.util.EventThreadJOptionPane;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PlayersPanel
extends JPanel {
    private static final long serialVersionUID = -4283654829822141065L;
    private final PlayerManager m_players;

    public PlayersPanel(PlayerManager players, GameData data) {
        this.m_players = players;
        this.setLayout(new BoxLayout(this, 1));
        for (String player : this.m_players.getPlayers()) {
            PlayerID playerID = data.getPlayerList().getPlayerID(player);
            if (playerID.isAI()) {
                this.add(new JLabel(playerID.getWhoAmI().split(":")[1] + " is " + playerID.getName(), 4));
                continue;
            }
            this.add(new JLabel(this.m_players.getNode(player).getName() + " is " + playerID.getName(), 4));
        }
    }

    public static void showPlayers(IGame game, Component parent) {
        PlayersPanel panel = new PlayersPanel(game.getPlayerManager(), game.getData());
        EventThreadJOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(parent), panel, "Players", -1);
    }
}

