/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ChatIgnoreList {
    private static final Logger log = Logger.getLogger(ChatIgnoreList.class.getName());
    private final Object m_lock = new Object();
    private final Set<String> m_ignore = new HashSet<String>();

    public ChatIgnoreList() {
        Preferences prefs = ChatIgnoreList.getPrefNode();
        try {
            for (String key : prefs.keys()) {
                this.m_ignore.add(key);
            }
        }
        catch (BackingStoreException e) {
            log.log(Level.FINE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_ignore.add(name);
            Preferences prefs = ChatIgnoreList.getPrefNode();
            prefs.put(name, "true");
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                log.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    protected static Preferences getPrefNode() {
        return Preferences.userNodeForPackage(ChatIgnoreList.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String name) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_ignore.remove(name);
            Preferences prefs = ChatIgnoreList.getPrefNode();
            prefs.remove(name);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                log.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldIgnore(String name) {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_ignore.contains(name);
        }
    }
}

