/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.CompositeIcon;
import games.strategy.engine.data.PlayerList;
import games.strategy.engine.data.PlayerManager;
import games.strategy.engine.framework.IGame;
import games.strategy.net.INode;
import games.strategy.triplea.ui.UIContext;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class PlayerChatRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -8195565028281374498L;
    private final IGame m_game;
    private final UIContext m_uiContext;
    int m_maxIconCounter = 0;
    HashMap<String, List<Icon>> m_iconMap = new HashMap();

    public PlayerChatRenderer(IGame game, UIContext uiContext) {
        this.m_game = game;
        this.m_uiContext = uiContext;
        this.setIconMap();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, ((INode)value).getName(), index, isSelected, cellHasFocus);
        List<Icon> icons = this.m_iconMap.get(value.toString());
        if (icons != null) {
            this.setHorizontalTextPosition(2);
            this.setIcon(new CompositeIcon(icons));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIconMap() {
        PlayerList playerList;
        PlayerManager playerManager = this.m_game.getPlayerManager();
        this.m_game.getData().acquireReadLock();
        try {
            playerList = this.m_game.getData().getPlayerList();
        }
        finally {
            this.m_game.getData().releaseReadLock();
        }
        for (INode playerNode : new HashSet<INode>(playerManager.getPlayerMapping().values())) {
            Set<String> players = playerManager.getPlayedBy(playerNode);
            if (players.size() <= 0) continue;
            ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>(players.size());
            for (String player : players) {
                icons.add(new ImageIcon(this.m_uiContext.getFlagImageFactory().getSmallFlag(playerList.getPlayerID(player))));
            }
            this.m_maxIconCounter = Math.max(this.m_maxIconCounter, icons.size());
            this.m_iconMap.put(playerNode.toString(), icons);
        }
    }

    public int getMaxIconCounter() {
        return this.m_maxIconCounter;
    }
}

