/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.BattleRecordsList;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.RemoveBattleRecordsChange;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import java.util.Map;

class AddBattleRecordsChange
extends Change {
    private static final long serialVersionUID = -6927678548172402611L;
    private final BattleRecords m_recordsToAdd;
    private final int m_round;

    AddBattleRecordsChange(BattleRecords battleRecords, GameData data) {
        this.m_round = data.getSequence().getRound();
        this.m_recordsToAdd = new BattleRecords(battleRecords);
    }

    AddBattleRecordsChange(BattleRecords battleRecords, int round) {
        this.m_round = round;
        this.m_recordsToAdd = battleRecords;
    }

    protected void perform(GameData data) {
        Map<Integer, BattleRecords> currentRecords = data.getBattleRecordsList().getBattleRecordsMap();
        BattleRecordsList.addRecords(currentRecords, this.m_round, new BattleRecords(this.m_recordsToAdd));
    }

    public Change invert() {
        return new RemoveBattleRecordsChange(this.m_recordsToAdd, this.m_round);
    }

    public String toString() {
        if (this.m_recordsToAdd == null) {
            throw new IllegalStateException("Records can not be null (most likely caused by improper or impossible serialization): " + this.m_recordsToAdd);
        }
        return "Adding Battle Records: " + this.m_recordsToAdd;
    }
}

