/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;

class ChangeResourceChange
extends Change {
    static final long serialVersionUID = -2304294240555842126L;
    private final String m_player;
    private final String m_resource;
    private final int m_quantity;

    ChangeResourceChange(PlayerID player, Resource resource, int quantity) {
        this.m_player = player.getName();
        this.m_resource = resource.getName();
        this.m_quantity = quantity;
    }

    private ChangeResourceChange(String player, String resource, int quantity) {
        this.m_player = player;
        this.m_resource = resource;
        this.m_quantity = quantity;
    }

    public Change invert() {
        return new ChangeResourceChange(this.m_player, this.m_resource, -this.m_quantity);
    }

    protected void perform(GameData data) {
        Resource resource = data.getResourceList().getResource(this.m_resource);
        ResourceCollection resources = data.getPlayerList().getPlayerID(this.m_player).getResources();
        if (this.m_quantity > 0) {
            resources.addResource(resource, this.m_quantity);
        } else if (this.m_quantity < 0) {
            resources.removeResource(resource, -this.m_quantity);
        }
    }

    public String toString() {
        return "Change resource.  Resource:" + this.m_resource + " quantity:" + this.m_quantity + " Player:" + this.m_player;
    }
}

