/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.util.PropertyUtil;
import java.io.IOException;
import java.io.ObjectInputStream;

class ObjectPropertyChange
extends Change {
    private static final long serialVersionUID = 4218093376094170940L;
    private final Object m_object;
    private String m_property;
    private Object m_newValue;
    private Object m_oldValue;

    public ObjectPropertyChange(Object object, String property, Object newValue) {
        this.m_object = object;
        this.m_property = property.intern();
        this.m_newValue = newValue;
        this.m_oldValue = PropertyUtil.getPropertyFieldObject(property, object);
    }

    private Object resolve(Object value) {
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        if (value instanceof Integer) {
            return (int)((Integer)value);
        }
        return value;
    }

    public ObjectPropertyChange(Object object, String property, Object newValue, Object oldValue) {
        this.m_object = object;
        this.m_property = property.intern();
        this.m_newValue = newValue;
        this.m_oldValue = oldValue;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.m_property = this.m_property.intern();
        this.m_newValue = this.resolve(this.m_newValue);
        this.m_oldValue = this.resolve(this.m_oldValue);
    }

    public Change invert() {
        return new ObjectPropertyChange(this.m_object, this.m_property, this.m_oldValue, this.m_newValue);
    }

    protected void perform(GameData data) {
        PropertyUtil.set(this.m_property, this.m_newValue, this.m_object);
    }

    public String toString() {
        return "Property change, unit:" + this.m_object + " property:" + this.m_property + " newValue:" + this.m_newValue + " oldValue:" + this.m_oldValue;
    }
}

