/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;

class PlayerWhoAmIChange
extends Change {
    private static final long serialVersionUID = -1486914230174337300L;
    private final String m_startWhoAmI;
    private final String m_endWhoAmI;
    private final String m_player;

    PlayerWhoAmIChange(String newWhoAmI, PlayerID player) {
        this.m_startWhoAmI = player.getWhoAmI();
        this.m_endWhoAmI = newWhoAmI;
        this.m_player = player.getName();
    }

    PlayerWhoAmIChange(String startWhoAmI, String endWhoAmI, String player) {
        this.m_startWhoAmI = startWhoAmI;
        this.m_endWhoAmI = endWhoAmI;
        this.m_player = player;
    }

    protected void perform(GameData data) {
        PlayerID player = data.getPlayerList().getPlayerID(this.m_player);
        player.setWhoAmI(this.m_endWhoAmI);
    }

    public Change invert() {
        return new PlayerWhoAmIChange(this.m_endWhoAmI, this.m_startWhoAmI, this.m_player);
    }

    public String toString() {
        return this.m_player + " changed from " + this.m_startWhoAmI + " to " + this.m_endWhoAmI;
    }
}

