/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.DefaultNamed;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.ProductionRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionFrontier
extends DefaultNamed
implements Iterable<ProductionRule> {
    private static final long serialVersionUID = -5967251608158552892L;
    private final List<ProductionRule> m_rules = new ArrayList<ProductionRule>();
    private List<ProductionRule> m_cachedRules;

    public ProductionFrontier(String name, GameData data) {
        super(name, data);
    }

    public void addRule(ProductionRule rule) {
        if (this.m_rules.contains(rule)) {
            throw new IllegalStateException("Rule already added:" + rule);
        }
        this.m_rules.add(rule);
        this.m_cachedRules = null;
    }

    public void removeRule(ProductionRule rule) {
        if (!this.m_rules.contains(rule)) {
            throw new IllegalStateException("Rule not present:" + rule);
        }
        this.m_rules.remove(rule);
        this.m_cachedRules = null;
    }

    public List<ProductionRule> getRules() {
        if (this.m_cachedRules == null) {
            this.m_cachedRules = Collections.unmodifiableList(this.m_rules);
        }
        return this.m_cachedRules;
    }

    @Override
    public Iterator<ProductionRule> iterator() {
        return this.getRules().iterator();
    }
}

