/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipInterpreter;
import games.strategy.engine.data.RelationshipType;
import games.strategy.triplea.attatchments.RelationshipTypeAttachment;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipTracker
extends RelationshipInterpreter {
    private static final long serialVersionUID = -4740671761925519069L;
    private final HashMap<RelatedPlayers, Relationship> m_relationships = new HashMap();

    public RelationshipTracker(GameData data) {
        super(data);
    }

    protected void setRelationship(PlayerID p1, PlayerID p2, RelationshipType r) {
        this.m_relationships.put(new RelatedPlayers(p1, p2), new Relationship(r));
    }

    protected void setRelationship(PlayerID p1, PlayerID p2, RelationshipType r, int roundValue) {
        this.m_relationships.put(new RelatedPlayers(p1, p2), new Relationship(r, roundValue));
    }

    @Override
    public RelationshipType getRelationshipType(PlayerID p1, PlayerID p2) {
        return this.getRelationship(p1, p2).getRelationshipType();
    }

    public Relationship getRelationship(PlayerID p1, PlayerID p2) {
        return this.m_relationships.get(new RelatedPlayers(p1, p2));
    }

    public HashSet<Relationship> getRelationships(PlayerID player1) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        for (PlayerID player2 : this.getData().getPlayerList().getPlayers()) {
            if (player2 == null || player2.equals(player1)) continue;
            relationships.add(this.getRelationship(player1, player2));
        }
        return relationships;
    }

    public int getRoundRelationshipWasCreated(PlayerID p1, PlayerID p2) {
        return this.m_relationships.get(new RelatedPlayers(p1, p2)).getRoundCreated();
    }

    protected RelationshipTypeAttachment getRelationshipTypeAttachment(PlayerID p1, PlayerID p2) {
        RelationshipType relation = this.getRelationshipType(p1, p2);
        return RelationshipTypeAttachment.get(relation);
    }

    protected void setSelfRelations() {
        for (PlayerID p : this.getData().getPlayerList().getPlayers()) {
            this.setRelationship(p, p, this.getSelfRelationshipType());
        }
        this.setRelationship(PlayerID.NULL_PLAYERID, PlayerID.NULL_PLAYERID, this.getSelfRelationshipType());
    }

    protected void setNullPlayerRelations() {
        for (PlayerID p : this.getData().getPlayerList().getPlayers()) {
            this.setRelationship(p, PlayerID.NULL_PLAYERID, this.getNullRelationshipType());
        }
    }

    private RelationshipType getSelfRelationshipType() {
        return this.getData().getRelationshipTypeList().getSelfRelation();
    }

    private RelationshipType getNullRelationshipType() {
        return this.getData().getRelationshipTypeList().getNullRelation();
    }

    public class Relationship
    implements Serializable {
        private static final long serialVersionUID = -6718866176901627180L;
        private final RelationshipType relationshipType;
        private final int roundCreated;

        public Relationship(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            this.roundCreated = RelationshipTracker.this.getData().getSequence().getRound();
        }

        public Relationship(RelationshipType relationshipType, int roundValue) {
            this.relationshipType = relationshipType;
            this.roundCreated = roundValue;
        }

        public int getRoundCreated() {
            return this.roundCreated;
        }

        public RelationshipType getRelationshipType() {
            return this.relationshipType;
        }

        public String toString() {
            return this.roundCreated + ":" + this.relationshipType;
        }
    }

    public class RelatedPlayers
    implements Serializable {
        private static final long serialVersionUID = 2124258606502106751L;
        private final PlayerID m_p1;
        private final PlayerID m_p2;

        public int hashCode() {
            return this.m_p1.hashCode() + this.m_p2.hashCode();
        }

        public RelatedPlayers(PlayerID p1, PlayerID p2) {
            this.m_p1 = p1;
            this.m_p2 = p2;
        }

        public boolean equals(Object object) {
            if (object instanceof RelatedPlayers) {
                RelatedPlayers relatedPlayers2 = (RelatedPlayers)object;
                return relatedPlayers2.m_p1.equals(this.m_p1) && relatedPlayers2.m_p2.equals(this.m_p2) || relatedPlayers2.m_p2.equals(this.m_p1) && relatedPlayers2.m_p1.equals(this.m_p2);
            }
            return super.equals(object);
        }

        public RelationshipType getRelationshipType() {
            return RelationshipTracker.this.getData().getRelationshipTracker().getRelationshipType(this.m_p1, this.m_p2);
        }

        public RelationshipTypeAttachment getRelationshipTypeAttachment() {
            return RelationshipTracker.this.getData().getRelationshipTracker().getRelationshipTypeAttachment(this.m_p1, this.m_p2);
        }

        public String toString() {
            return this.m_p1.getName() + "-" + this.m_p2.getName();
        }
    }
}

