/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.AddBattleRecordsChange;
import games.strategy.engine.data.BattleRecordsList;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.triplea.delegate.dataObjects.BattleRecords;
import java.util.Map;

class RemoveBattleRecordsChange
extends Change {
    private static final long serialVersionUID = 3286634991233029854L;
    private final BattleRecords m_recordsToRemove;
    private final int m_round;

    RemoveBattleRecordsChange(BattleRecords battleRecords, int round) {
        this.m_round = round;
        this.m_recordsToRemove = battleRecords;
    }

    protected void perform(GameData data) {
        Map<Integer, BattleRecords> currentRecords = data.getBattleRecordsList().getBattleRecordsMap();
        BattleRecordsList.removeRecords(currentRecords, this.m_round, new BattleRecords(this.m_recordsToRemove));
    }

    public Change invert() {
        return new AddBattleRecordsChange(this.m_recordsToRemove, this.m_round);
    }

    public String toString() {
        if (this.m_recordsToRemove == null) {
            throw new IllegalStateException("Records can not be null (most likely caused by improper or impossible serialization): " + this.m_recordsToRemove);
        }
        return "Adding Battle Records: " + this.m_recordsToRemove;
    }
}

