/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechnologyFrontier
extends GameDataComponent
implements Iterable<TechAdvance> {
    private static final long serialVersionUID = -5245743727479551766L;
    private final List<TechAdvance> m_techs = new ArrayList<TechAdvance>();
    private List<TechAdvance> m_cachedTechs;
    private final String m_name;

    public TechnologyFrontier(String name, GameData data) {
        super(data);
        this.m_name = name;
    }

    public TechnologyFrontier(TechnologyFrontier other) {
        super(other.getData());
        this.m_name = other.m_name;
        this.m_techs.addAll(other.m_techs);
    }

    public void addAdvance(TechAdvance t) {
        this.m_cachedTechs = null;
        this.m_techs.add(t);
        Util.reorder(this.m_techs, this.getData().getTechnologyFrontier().getTechs());
    }

    public void addAdvance(List<TechAdvance> list) {
        for (TechAdvance t : list) {
            this.addAdvance(t);
        }
    }

    public void removeAdvance(TechAdvance t) {
        if (!this.m_techs.contains(t)) {
            throw new IllegalStateException("Advance not present:" + t);
        }
        this.m_cachedTechs = null;
        this.m_techs.remove(t);
    }

    public TechAdvance getAdvanceByProperty(String property) {
        for (TechAdvance ta : this.m_techs) {
            if (!ta.getProperty().equals(property)) continue;
            return ta;
        }
        return null;
    }

    public TechAdvance getAdvanceByName(String name) {
        for (TechAdvance ta : this.m_techs) {
            if (!ta.getName().equals(name)) continue;
            return ta;
        }
        return null;
    }

    public List<TechAdvance> getTechs() {
        if (this.m_cachedTechs == null) {
            this.m_cachedTechs = Collections.unmodifiableList(this.m_techs);
        }
        return this.m_cachedTechs;
    }

    @Override
    public Iterator<TechAdvance> iterator() {
        return this.getTechs().iterator();
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isEmpty() {
        return this.m_techs.isEmpty();
    }

    public String toString() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof TechnologyFrontier)) {
            return false;
        }
        TechnologyFrontier other = (TechnologyFrontier)o;
        return this.m_name.equals(other.getName());
    }
}

