/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.DefaultAttachmentExporter;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.delegate.TechAdvance;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RulesAttachmentExporter
extends DefaultAttachmentExporter {
    protected String printOption(Field field, IAttachment attachment) throws AttachmentExportException {
        String fieldName = field.getName();
        if (fieldName.equals("m_turns")) {
            return this.mTurnsHandler(field, attachment);
        }
        if (fieldName.equals("m_unitPresence")) {
            return this.mUnitPresenceHandler(field, attachment);
        }
        if (fieldName.equals("m_productionPerXTerritories")) {
            return this.mProductionPerXTerritoriesHandler(field, attachment);
        }
        if (fieldName.equals("m_atWarPlayers")) {
            return this.mAtWarPlayersHandler(field, attachment);
        }
        if (fieldName.equals("m_atWarCount")) {
            return "";
        }
        if (fieldName.equals("m_territoryCount")) {
            return "";
        }
        if (fieldName.matches("m_allied.*Territories") || fieldName.matches("m_enemy.*Territories") || fieldName.matches("m_direct.*Territories")) {
            return this.territoryCountListHandler(field, attachment, fieldName);
        }
        if (fieldName.equals("m_techs")) {
            return this.mTechsHandler(field, attachment);
        }
        if (fieldName.equals("m_techCount")) {
            return "";
        }
        return super.printOption(field, attachment);
    }

    private String territoryCountListHandler(Field field, IAttachment attachment, String fieldName) throws AttachmentExportException {
        try {
            String[] valueArray = (String[])field.get(attachment);
            if (valueArray == null || valueArray.length == 0) {
                return "";
            }
            Iterator<String> values = Arrays.asList(valueArray).iterator();
            if (valueArray.length > 1) {
                values.next();
            }
            String returnValue = values.next();
            while (values.hasNext()) {
                returnValue = returnValue + ":" + values.next();
            }
            if (returnValue.length() == 0) {
                return "";
            }
            String count = "" + ((RulesAttachment)attachment).getTerritoryCount();
            return this.printCountOption(fieldName.substring(2), returnValue, count);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for territoryCountListHandler on option: " + fieldName + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for territoryCountListHandler on option: " + fieldName + " on Attachment: " + attachment.getName());
        }
        catch (SecurityException e) {
            throw new AttachmentExportException("e: " + e + " for territoryCountListHandler on option: " + fieldName + " on Attachment: " + attachment.getName());
        }
    }

    private String mAtWarPlayersHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            Set atWarPlayers = (Set)field.get(attachment);
            if (atWarPlayers == null) {
                return "";
            }
            String option = "" + Character.toLowerCase(field.getName().charAt(2)) + field.getName().substring(3);
            Field atWarPlayerCountField = RulesAttachment.class.getDeclaredField("m_atWarCount");
            atWarPlayerCountField.setAccessible(true);
            int count = atWarPlayerCountField.getInt(attachment);
            Iterator iWarPlayer = atWarPlayers.iterator();
            String value = ((PlayerID)iWarPlayer.next()).getName();
            while (iWarPlayer.hasNext()) {
                value = value + ":" + ((PlayerID)iWarPlayer.next()).getName();
            }
            return this.printCountOption(option, value, "" + count);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mAtWarPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mAtWarPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (SecurityException e) {
            throw new AttachmentExportException("e: " + e + " for mAtWarPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (NoSuchFieldException e) {
            throw new AttachmentExportException("e: " + e + " for mAtWarPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mUnitPresenceHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printUnitIntegerMap(field, attachment);
    }

    private String mProductionPerXTerritoriesHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printUnitIntegerMap(field, attachment);
    }

    private String mTurnsHandler(Field field, IAttachment attachment) {
        Object oValue = null;
        try {
            oValue = field.get(attachment);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String intList = "";
        HashMap intMap = (HashMap)oValue;
        if (intMap == null) {
            return "";
        }
        for (Integer curInt : intMap.keySet()) {
            int start = curInt;
            int end = (Integer)intMap.get(curInt);
            if (intList.length() > 0) {
                intList = intList + ":";
            }
            if (start == end) {
                intList = intList + start;
                continue;
            }
            if (end == Integer.MAX_VALUE) {
                intList = intList + start + "-+";
                continue;
            }
            intList = intList + start + "-" + end;
        }
        return this.printDefaultOption("turns", intList);
    }

    private String mTechsHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            List techAdvanceList = (List)field.get(attachment);
            if (techAdvanceList == null) {
                return "";
            }
            Iterator iTechAdvances = techAdvanceList.iterator();
            String returnValue = "";
            if (iTechAdvances.hasNext()) {
                returnValue = ((TechAdvance)iTechAdvances.next()).getName();
            }
            while (iTechAdvances.hasNext()) {
                returnValue = returnValue + ":" + ((TechAdvance)iTechAdvances.next()).getName();
            }
            if (returnValue.length() == 0) {
                return "";
            }
            return super.printCountOption("techs", returnValue, "" + ((RulesAttachment)attachment).getTechCount());
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mTechHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mTechHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }
}

