/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ColorProperty
extends AEditableProperty {
    private static final long serialVersionUID = 6826763550643504789L;
    private final int m_max = 0xFFFFFF;
    private final int m_min = 0;
    private Color m_color;

    public ColorProperty(String name, String description, int def) {
        super(name, description);
        if (def > 0xFFFFFF || def < 0) {
            throw new IllegalThreadStateException("Default value out of range");
        }
        this.m_color = new Color(def);
    }

    public ColorProperty(String name, String description, Color def) {
        super(name, description);
        this.m_color = def;
    }

    public Object getValue() {
        return this.m_color;
    }

    public void setValue(Object value) throws ClassCastException {
        this.m_color = (Color)value;
    }

    public JComponent getEditorComponent() {
        final JLabel label = new JLabel("        "){
            private static final long serialVersionUID = 3833935337866905836L;

            public void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(ColorProperty.this.m_color);
                g2.fill(g2.getClip());
            }
        };
        label.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                System.out.println(ColorProperty.this.m_color);
                ColorProperty.this.m_color = JColorChooser.showDialog(label, "Choose color", ColorProperty.this.m_color);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        label.repaint();
                    }
                });
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        return label;
    }
}

