/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.startup.ui.MainFrame;
import java.awt.FileDialog;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class FileProperty
extends AEditableProperty {
    private static final long serialVersionUID = 6826763550643504789L;
    private File m_file;
    private final String[] m_acceptableSuffixes;

    public FileProperty(String name, String description, String fileName) {
        super(name, description);
        this.m_file = new File(fileName);
        if (!this.m_file.exists()) {
            this.m_file = null;
        }
        this.m_acceptableSuffixes = new String[]{"png", "jpg", "jpeg", "gif"};
    }

    public FileProperty(String name, String description, File file) {
        this(name, description, file, new String[]{"png", "jpg", "jpeg", "gif"});
    }

    public FileProperty(String name, String description, File file, String[] acceptableSuffixes) {
        super(name, description);
        this.m_file = file.exists() ? file : null;
        this.m_acceptableSuffixes = acceptableSuffixes;
    }

    public Object getValue() {
        return this.m_file;
    }

    public void setValue(Object value) throws ClassCastException {
        this.m_file = (File)value;
    }

    public JComponent getEditorComponent() {
        final JTextField label = this.m_file == null ? new JTextField() : new JTextField(this.m_file.getAbsolutePath());
        label.setEditable(false);
        label.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                File selection = FileProperty.this.getFileUsingDialog(FileProperty.this.m_acceptableSuffixes);
                if (selection != null) {
                    FileProperty.this.m_file = selection;
                    label.setText(FileProperty.this.m_file.getAbsolutePath());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            label.repaint();
                        }
                    });
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        return label;
    }

    private File getFileUsingDialog(final String ... acceptableSuffixes) {
        if (GameRunner.isMac()) {
            FileDialog fileDialog = new FileDialog(MainFrame.getInstance());
            fileDialog.setMode(0);
            fileDialog.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (acceptableSuffixes == null || acceptableSuffixes.length == 0) {
                        return true;
                    }
                    for (String suffix : acceptableSuffixes) {
                        if (!name.toLowerCase().endsWith(suffix)) continue;
                        return true;
                    }
                    return false;
                }
            });
            fileDialog.setVisible(true);
            String fileName = fileDialog.getFile();
            String dirName = fileDialog.getDirectory();
            if (fileName == null) {
                return null;
            }
            return new File(dirName, fileName);
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String name = file.getAbsolutePath().toLowerCase();
                for (String suffix : acceptableSuffixes) {
                    if (!name.endsWith(suffix)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return Arrays.toString(acceptableSuffixes);
            }
        });
        int rVal = fileChooser.showOpenDialog(MainFrame.getInstance());
        if (rVal == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

