/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.data.properties.BooleanProperty;
import games.strategy.engine.data.properties.CollectionProperty;
import games.strategy.engine.data.properties.ColorProperty;
import games.strategy.engine.data.properties.DoubleProperty;
import games.strategy.engine.data.properties.FileProperty;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.data.properties.NumberProperty;
import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.engine.data.properties.StringProperty;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapProperty<T, U>
extends AEditableProperty {
    private static final long serialVersionUID = -8021039503574228146L;
    private Map<T, U> m_map;
    final List<IEditableProperty> m_properties = new ArrayList<IEditableProperty>();

    public MapProperty(String name, String description, Map<T, U> map) {
        super(name, description);
        this.m_map = map;
        for (Map.Entry<T, U> entry : map.entrySet()) {
            String key = (String)entry.getKey();
            U value = entry.getValue();
            if (value instanceof Boolean) {
                this.m_properties.add(new BooleanProperty(key, description, (Boolean)value));
                continue;
            }
            if (value instanceof Color) {
                this.m_properties.add(new ColorProperty(key, description, (Color)value));
                continue;
            }
            if (value instanceof File) {
                this.m_properties.add(new FileProperty(key, description, (File)value));
                continue;
            }
            if (value instanceof String) {
                this.m_properties.add(new StringProperty(key, description, (String)value));
                continue;
            }
            if (value instanceof Collection || value instanceof List || value instanceof Set) {
                this.m_properties.add(new CollectionProperty(name, description, (Collection)value));
                continue;
            }
            if (value instanceof Integer) {
                this.m_properties.add(new NumberProperty(key, description, Integer.MAX_VALUE, Integer.MIN_VALUE, (Integer)value));
                continue;
            }
            if (value instanceof Double) {
                this.m_properties.add(new DoubleProperty(key, description, Double.MAX_VALUE, Double.MIN_VALUE, (Double)value, 5));
                continue;
            }
            throw new IllegalArgumentException("Can not instantiate MapProperty with: " + value.getClass().getCanonicalName());
        }
    }

    @Override
    public int getRowsNeeded() {
        return Math.max(1, this.m_properties.size());
    }

    @Override
    public Object getValue() {
        return this.m_map;
    }

    public Map<T, U> getValueT() {
        return this.m_map;
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        this.m_map = (Map)value;
    }

    public void setValueT(Map<T, U> value) {
        this.m_map = value;
    }

    @Override
    public JComponent getEditorComponent() {
        PropertiesUI ui = new PropertiesUI(this.m_properties, true);
        return ui;
    }

    @Override
    public JComponent getViewComponent() {
        PropertiesUI ui = new PropertiesUI(this.m_properties, false);
        return ui;
    }
}

