/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.framework.GameRunner;
import games.strategy.ui.IntTextField;
import games.strategy.ui.IntTextFieldChangeListener;
import java.io.File;
import javax.swing.JComponent;

public class NumberProperty
extends AEditableProperty {
    private static final long serialVersionUID = 6826763550643504789L;
    private final int m_max;
    private final int m_min;
    private int m_value;

    public NumberProperty(String name, String description, int max, int min, int def) {
        super(name, description);
        if (max < min) {
            throw new IllegalThreadStateException("Max must be greater than min");
        }
        if (def > max || def < min) {
            throw new IllegalThreadStateException("Default value out of range");
        }
        this.m_max = max;
        this.m_min = min;
        this.m_value = def;
    }

    public Integer getValue() {
        return this.m_value;
    }

    public void setValue(Object value) throws ClassCastException {
        if (value instanceof String) {
            throw new RuntimeException("Number properties are no longer stored as Strings. You should delete your option cache, located at " + new File(GameRunner.getUserRootFolder(), "optionCache").toString());
        }
        this.m_value = (Integer)value;
    }

    public JComponent getEditorComponent() {
        IntTextField field = new IntTextField(this.m_min, this.m_max);
        field.setValue(this.m_value);
        field.addChangeListener(new IntTextFieldChangeListener(){

            public void changedValue(IntTextField aField) {
                NumberProperty.this.m_value = aField.getValue();
            }
        });
        return field;
    }
}

