/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.debug.Console;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.background.WaitWindow;
import games.strategy.triplea.ui.ErrorHandler;
import games.strategy.triplea.ui.TripleaMenu;
import games.strategy.util.Version;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.logging.LogManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.httpclient.HostConfiguration;

public class GameRunner2 {
    public static final String LOOK_AND_FEEL_PREF = "LookAndFeel";
    public static final String DELAYED_PARSING = "DelayedParsing";
    public static final String PROXY_CHOICE = "proxy.choice";
    public static final String HTTP_PROXYHOST = "http.proxyHost";
    public static final String HTTP_PROXYPORT = "http.proxyPort";
    public static final String OLD_EXTENSION = ".old";
    public static final String TRIPLEA_GAME_PROPERTY = "triplea.game";
    public static final String TRIPLEA_SERVER_PROPERTY = "triplea.server";
    public static final String TRIPLEA_CLIENT_PROPERTY = "triplea.client";
    public static final String TRIPLEA_HOST_PROPERTY = "triplea.host";
    public static final String TRIPLEA_PORT_PROPERTY = "triplea.port";
    public static final String TRIPLEA_NAME_PROPERTY = "triplea.name";
    public static final String TRIPLEA_SERVER_PASSWORD_PROPERTY = "triplea.server.password";
    public static final String TRIPLEA_STARTED = "triplea.started";
    public static final String LOBBY_PORT = "triplea.lobby.port";
    public static final String LOBBY_HOST = "triplea.lobby.host";
    public static final String LOBBY_GAME_COMMENTS = "triplea.lobby.game.comments";
    public static final String LOBBY_GAME_HOSTED_BY = "triplea.lobby.game.hostedBy";
    public static final String TRIPLEA_ENGINE_VERSION_BIN = "triplea.engine.version.bin";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    private static WaitWindow waitWindow;

    public static String[] getProperties() {
        return new String[]{TRIPLEA_GAME_PROPERTY, TRIPLEA_SERVER_PROPERTY, TRIPLEA_CLIENT_PROPERTY, TRIPLEA_HOST_PROPERTY, TRIPLEA_PORT_PROPERTY, TRIPLEA_NAME_PROPERTY, TRIPLEA_SERVER_PASSWORD_PROPERTY, TRIPLEA_STARTED, LOBBY_PORT, LOBBY_HOST, LOBBY_GAME_COMMENTS, LOBBY_GAME_HOSTED_BY, TRIPLEA_ENGINE_VERSION_BIN, PROXY_HOST, PROXY_PORT};
    }

    private static void usage() {
        System.out.println("Arguments\n   triplea.game=<FILE_NAME>\n   triplea.server=true\n   triplea.client=true\n   triplea.host=<HOST_IP>\n   triplea.port=<PORT>\n   triplea.name=<PLAYER_NAME>\n   triplea.lobby.port=<LOBBY_PORT>\n   triplea.lobby.host=<LOBBY_HOST>\n   triplea.lobby.game.comments=<LOBBY_GAME_COMMENTS>\n   triplea.lobby.game.hostedBy=<LOBBY_GAME_HOSTED_BY>\n   proxy.host=<Proxy_Host>\n   proxy.port=<Proxy_Port>\n\nif there is only one argument, and it does not start with triplea.game, the argument will be \ntaken as the name of the file to load.\n\nExample\n   to start a game using the given file:\n\n   triplea /home/sgb/games/test.xml\n\n   or\n\n   triplea triplea.game=/home/sgb/games/test.xml\n\n   to connect to a remote host:\n\n   triplea triplea.client=true triplea.host=127.0.0.0 triplea.port=3300 triplea.name=Paul\n\n   to start a server with the given game\n\n   triplea triplea.game=/home/sgb/games/test.xml triplea.server=true triplea.port=3300 triplea.name=Allan\n   to start a server, you can optionally password protect the game using triplea.server.password=foo");
    }

    public static void main(String[] args) {
        GameRunner2.setupLogging();
        Console.getConsole().displayStandardError();
        Console.getConsole().displayStandardOutput();
        System.setProperty("sun.awt.exception.handler", ErrorHandler.class.getName());
        System.setProperty("triplea.engine.version", EngineVersion.VERSION.toString());
        GameRunner2.setupLookAndFeel();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    waitWindow = new WaitWindow("TripleA is starting...");
                    waitWindow.setVisible(true);
                    waitWindow.showWait();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameRunner2.handleCommandLineArgs(args);
        GameRunner2.setupProxies();
        GameRunner2.showMainFrame();
    }

    private static void showMainFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame frame = new MainFrame();
                frame.start();
                frame.requestFocus();
                frame.toFront();
                if (waitWindow != null) {
                    waitWindow.doneWait();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleCommandLineArgs(String[] args) {
        String[] properties = GameRunner2.getProperties();
        if (args.length == 1) {
            String value = args[0].startsWith(TRIPLEA_GAME_PROPERTY) ? GameRunner2.getValue(args[0]) : args[0];
            System.setProperty(TRIPLEA_GAME_PROPERTY, value);
        } else {
            boolean usagePrinted = false;
            for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                boolean found = false;
                String arg = args[argIndex];
                int indexOf = arg.indexOf(61);
                if (indexOf > 0) {
                    arg = arg.substring(0, indexOf);
                    for (int propIndex = 0; propIndex < properties.length; ++propIndex) {
                        if (!arg.equals(properties[propIndex])) continue;
                        String value = GameRunner2.getValue(args[argIndex]);
                        System.getProperties().setProperty(properties[propIndex], value);
                        System.out.println(properties[propIndex] + ":" + value);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                System.out.println("Unrecogized:" + args[argIndex]);
                if (usagePrinted) continue;
                usagePrinted = true;
                GameRunner2.usage();
            }
        }
        String version = System.getProperty(TRIPLEA_ENGINE_VERSION_BIN);
        if (version != null && version.length() > 0) {
            try {
                Version testVersion = new Version(version);
                System.out.println("triplea.engine.version.bin:" + version);
                if (EngineVersion.VERSION.equals(testVersion, false)) return;
                System.out.println("Current Engine version in use: " + EngineVersion.VERSION.toString());
                return;
            }
            catch (Exception e) {
                System.getProperties().setProperty(TRIPLEA_ENGINE_VERSION_BIN, EngineVersion.VERSION.toString());
                System.out.println("triplea.engine.version.bin:" + EngineVersion.VERSION.toString());
                return;
            }
        } else {
            System.getProperties().setProperty(TRIPLEA_ENGINE_VERSION_BIN, EngineVersion.VERSION.toString());
            System.out.println("triplea.engine.version.bin:" + EngineVersion.VERSION.toString());
        }
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    public static void setupLookAndFeel() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    block4: {
                        try {
                            UIManager.setLookAndFeel(GameRunner2.getDefaultLookAndFeel());
                        }
                        catch (Throwable t) {
                            if (GameRunner.isMac()) break block4;
                            try {
                                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public static void setupLogging() {
        try {
            LogManager.getLogManager().readConfiguration(ClassLoader.getSystemResourceAsStream("logging.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDefaultLookAndFeel() {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        String defaultLookAndFeel = "org.jvnet.substance.skin.SubstanceRavenGraphiteLookAndFeel";
        if (GameRunner.isMac()) {
            defaultLookAndFeel = UIManager.getSystemLookAndFeelClassName();
        }
        String userDefault = pref.get(LOOK_AND_FEEL_PREF, defaultLookAndFeel);
        List<String> availableSkins = TripleaMenu.getLookAndFeelAvailableList();
        if (!availableSkins.contains(userDefault)) {
            if (!availableSkins.contains(defaultLookAndFeel)) {
                return UIManager.getSystemLookAndFeelClassName();
            }
            GameRunner2.setDefaultLookAndFeel(defaultLookAndFeel);
            return defaultLookAndFeel;
        }
        return userDefault;
    }

    public static void setDefaultLookAndFeel(String lookAndFeelClassName) {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        pref.put(LOOK_AND_FEEL_PREF, lookAndFeelClassName);
        try {
            pref.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private static void setupProxies() {
        Preferences pref;
        ProxyChoice choice;
        String proxyHostArgument = System.getProperty(PROXY_HOST);
        String proxyPortArgument = System.getProperty(PROXY_PORT);
        if (proxyHostArgument == null) {
            proxyHostArgument = System.getProperty(HTTP_PROXYHOST);
        }
        if (proxyPortArgument == null) {
            proxyPortArgument = System.getProperty(HTTP_PROXYPORT);
        }
        String proxyHost = null;
        if (proxyHostArgument != null && proxyHostArgument.trim().length() > 0) {
            proxyHost = proxyHostArgument;
        }
        String proxyPort = null;
        if (proxyPortArgument != null && proxyPortArgument.trim().length() > 0) {
            try {
                Integer.parseInt(proxyPortArgument);
                proxyPort = proxyPortArgument;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if (proxyHost != null || proxyPort != null) {
            GameRunner2.setProxy(proxyHost, proxyPort, ProxyChoice.USE_USER_PREFERENCES);
        }
        if ((choice = ProxyChoice.valueOf((pref = Preferences.userNodeForPackage(GameRunner2.class)).get(PROXY_CHOICE, ProxyChoice.NONE.toString()))) == ProxyChoice.USE_SYSTEM_SETTINGS) {
            GameRunner2.setToUseSystemProxies();
        } else if (choice == ProxyChoice.USE_USER_PREFERENCES) {
            String host = pref.get(PROXY_HOST, "");
            String port = pref.get(PROXY_PORT, "");
            if (host.trim().length() > 0) {
                System.setProperty(HTTP_PROXYHOST, host);
            }
            if (port.trim().length() > 0) {
                System.setProperty(HTTP_PROXYPORT, port);
            }
        }
    }

    public static void setProxy(String proxyHost, String proxyPort, ProxyChoice proxyChoice) {
        ProxyChoice choice;
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        if (proxyChoice != null) {
            choice = proxyChoice;
            pref.put(PROXY_CHOICE, proxyChoice.toString());
        } else {
            choice = ProxyChoice.valueOf(pref.get(PROXY_CHOICE, ProxyChoice.NONE.toString()));
        }
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            pref.put(PROXY_HOST, proxyHost);
            if (choice == ProxyChoice.USE_USER_PREFERENCES) {
                System.setProperty(HTTP_PROXYHOST, proxyHost);
            }
        }
        if (proxyPort != null && proxyPort.trim().length() > 0) {
            try {
                Integer.parseInt(proxyPort);
                pref.put(PROXY_PORT, proxyPort);
                if (choice == ProxyChoice.USE_USER_PREFERENCES) {
                    System.setProperty(HTTP_PROXYPORT, proxyPort);
                }
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if (choice == ProxyChoice.NONE) {
            System.clearProperty(HTTP_PROXYHOST);
            System.clearProperty(HTTP_PROXYPORT);
        } else if (choice == ProxyChoice.USE_SYSTEM_SETTINGS) {
            GameRunner2.setToUseSystemProxies();
        }
        if (proxyHost != null || proxyPort != null || proxyChoice != null) {
            try {
                pref.flush();
                pref.sync();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setToUseSystemProxies() {
        String JAVA_NET_USESYSTEMPROXIES = "java.net.useSystemProxies";
        System.setProperty("java.net.useSystemProxies", "true");
        List<Proxy> proxyList = null;
        try {
            ProxySelector def = ProxySelector.getDefault();
            if (def != null) {
                proxyList = def.select(new URI("http://sourceforge.net/"));
                ProxySelector.setDefault(null);
                if (proxyList != null && !proxyList.isEmpty()) {
                    Proxy proxy = proxyList.get(0);
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    if (address != null) {
                        String host = address.getHostName();
                        int port = address.getPort();
                        System.setProperty(HTTP_PROXYHOST, host);
                        System.setProperty(HTTP_PROXYPORT, Integer.toString(port));
                        System.setProperty(PROXY_HOST, host);
                        System.setProperty(PROXY_PORT, Integer.toString(port));
                    } else {
                        System.clearProperty(HTTP_PROXYHOST);
                        System.clearProperty(HTTP_PROXYPORT);
                        System.clearProperty(PROXY_HOST);
                        System.clearProperty(PROXY_PORT);
                    }
                }
            } else {
                String host = System.getProperty(PROXY_HOST);
                String port = System.getProperty(PROXY_PORT);
                if (host == null) {
                    System.clearProperty(HTTP_PROXYHOST);
                } else {
                    System.setProperty(HTTP_PROXYHOST, host);
                }
                if (port == null) {
                    System.clearProperty(HTTP_PROXYPORT);
                } else {
                    try {
                        Integer.parseInt(port);
                        System.setProperty(HTTP_PROXYPORT, port);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.setProperty("java.net.useSystemProxies", "false");
        }
    }

    public static void addProxy(HostConfiguration config) {
        String host = System.getProperty(HTTP_PROXYHOST);
        String port = System.getProperty(HTTP_PROXYPORT, "-1");
        if (host != null && host.trim().length() > 0) {
            config.setProxy(host, Integer.valueOf(port));
        }
    }

    public static boolean getDelayedParsing() {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        return pref.getBoolean(DELAYED_PARSING, true);
    }

    public static void setDelayedParsing(boolean delayedParsing) {
        Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
        pref.putBoolean(DELAYED_PARSING, delayedParsing);
        try {
            pref.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProxyChoice {
        NONE,
        USE_SYSTEM_SETTINGS,
        USE_USER_PREFERENCES;

    }
}

