/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework;

import games.strategy.engine.framework.GameRunner;
import games.strategy.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRunnerUtil {
    public static void populateBasicJavaArgs(List<String> commands) {
        ProcessRunnerUtil.populateBasicJavaArgs(commands, System.getProperty("java.class.path"));
    }

    public static void populateBasicJavaArgs(List<String> commands, long maxMemory) {
        ProcessRunnerUtil.populateBasicJavaArgs(commands, System.getProperty("java.class.path"), maxMemory);
    }

    public static void populateBasicJavaArgs(List<String> commands, String newClasspath) {
        long maxMemory = (long)((double)Runtime.getRuntime().maxMemory() * 1.15) + 0x4000000L;
        ProcessRunnerUtil.populateBasicJavaArgs(commands, newClasspath, maxMemory);
    }

    public static void populateBasicJavaArgs(List<String> commands, String classpath, long maxMemory) {
        String version;
        String[] preservedSystemProperties;
        String javaCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        commands.add(javaCommand);
        commands.add("-classpath");
        if (classpath != null && classpath.length() > 0) {
            commands.add(classpath);
        } else {
            commands.add(System.getProperty("java.class.path"));
        }
        commands.add("-Xmx" + maxMemory);
        for (String key : preservedSystemProperties = new String[]{"sun.java2d.noddraw"}) {
            String value;
            if (System.getProperties().getProperty(key) == null || !(value = System.getProperties().getProperty(key)).matches("[a-zA-Z0-9.]+")) continue;
            commands.add("-D" + key + "=" + value);
        }
        if (GameRunner.isMac()) {
            commands.add("-Dapple.laf.useScreenMenuBar=true");
            commands.add("-Xdock:name=\"TripleA\"");
            File icons = new File(GameRunner.getRootFolder(), "icons/triplea_icon.png");
            if (!icons.exists()) {
                throw new IllegalStateException("Icon file not found");
            }
            commands.add("-Xdock:icon=" + icons.getAbsolutePath() + "");
        }
        if ((version = System.getProperty("triplea.engine.version.bin")) != null && version.length() > 0) {
            try {
                Version testVersion = new Version(version);
                commands.add("-Dtriplea.engine.version.bin=" + testVersion.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void exec(List<String> commands) {
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        try {
            Process p = builder.start();
            final InputStream s = p.getInputStream();
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        while (s.read() >= 0) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, "Process ouput gobbler");
            t.setDaemon(true);
            t.start();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

