/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.mapDownload;

import games.strategy.engine.framework.mapDownload.DownloadFileDescription;
import games.strategy.engine.framework.mapDownload.DownloadFileParser;
import games.strategy.engine.framework.mapDownload.DownloadRunnable;
import games.strategy.engine.framework.mapDownload.InstallMapDialog;
import games.strategy.engine.framework.ui.background.BackgroundTaskRunner;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.ui.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class DownloadMapDialog
extends JDialog {
    private static final long serialVersionUID = -4719699814187468325L;
    private JComboBox m_urlComboBox;
    private JButton m_listGamesButton;
    private JButton m_cancelButton;
    private JButton m_findMapsButton;
    private final String DOWNLOAD_SITES_PREF = "downloadSites";
    private final Frame owner;

    private DownloadMapDialog(Frame owner) {
        super(owner, "Select Download Site", true);
        this.owner = owner;
        this.createComponents();
        this.layoutCoponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_listGamesButton = new JButton("List Games");
        this.m_cancelButton = new JButton("Cancel");
        this.m_findMapsButton = new JButton("Find Maps and Games");
        this.m_urlComboBox = new JComboBox(this.getStoredDownloadSites());
        this.m_urlComboBox.setEditable(true);
        this.m_urlComboBox.setPrototypeDisplayValue("                                                                                                                                                                            ");
    }

    private void layoutCoponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.add((Component)buttonsPanel, "South");
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(this.m_cancelButton);
        buttonsPanel.add(this.m_findMapsButton);
        buttonsPanel.add(this.m_listGamesButton);
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel main = new JPanel();
        main.setBorder(new EmptyBorder(30, 30, 30, 30));
        main.setLayout(new BoxLayout(main, 0));
        main.add(new JLabel("Select download site:"));
        main.add(this.m_urlComboBox);
        this.add((Component)main, "Center");
    }

    private void setupListeners() {
        this.m_cancelButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1410141388231981589L;

            public void actionPerformed(ActionEvent e) {
                DownloadMapDialog.this.setVisible(false);
            }
        });
        this.m_listGamesButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -9051243018211311068L;

            public void actionPerformed(ActionEvent event) {
                List<DownloadFileDescription> downloads;
                String selectedUrl = (String)DownloadMapDialog.this.m_urlComboBox.getSelectedItem();
                if (selectedUrl == null || selectedUrl.trim().length() == 0) {
                    Util.notifyError(DownloadMapDialog.this.m_cancelButton, "nothing selected");
                    return;
                }
                DownloadRunnable download = new DownloadRunnable(selectedUrl);
                BackgroundTaskRunner.runInBackground(DownloadMapDialog.this.getRootPane(), "Downloading....", download);
                if (download.getError() != null) {
                    Util.notifyError(DownloadMapDialog.this.m_cancelButton, download.getError());
                    return;
                }
                try {
                    downloads = new DownloadFileParser().parse(new ByteArrayInputStream(download.getContents()), selectedUrl);
                    if (downloads.isEmpty()) {
                        throw new IllegalStateException("No games listed.");
                    }
                }
                catch (Exception e) {
                    Util.notifyError(DownloadMapDialog.this.m_cancelButton, e.getMessage());
                    return;
                }
                DownloadMapDialog.this.addDownloadSites(selectedUrl.trim());
                DownloadMapDialog.this.setVisible(false);
                InstallMapDialog.installGames(DownloadMapDialog.this.owner, downloads);
            }
        });
        this.m_findMapsButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -4644282981460989512L;

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312p4074312.html");
                }
                catch (Exception ex) {
                    Util.notifyError(DownloadMapDialog.this.m_cancelButton, ex.getMessage());
                    return;
                }
            }
        });
    }

    private Vector getStoredDownloadSites() {
        Preferences pref = this.getPrefNode();
        byte[] stored = pref.getByteArray("downloadSites", null);
        if (stored == null) {
            return new Vector();
        }
        try {
            return (Vector)new ObjectInputStream(new ByteArrayInputStream(stored)).readObject();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.out);
        }
        return new Vector();
    }

    private Preferences getPrefNode() {
        return Preferences.userNodeForPackage(DownloadMapDialog.class);
    }

    private void addDownloadSites(String url) {
        Vector<String> old = this.getStoredDownloadSites();
        old.remove(url);
        old.add(0, url);
        if (old.size() > 10) {
            old = new Vector<String>(old.subList(0, 10));
        }
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        try {
            ObjectOutputStream writer = new ObjectOutputStream(sink);
            writer.writeObject(old);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (sink.toByteArray().length > 0) {
            this.getPrefNode().putByteArray("downloadSites", sink.toByteArray());
        }
    }

    private void setWidgetActivation() {
    }

    public static void downloadGames(JComponent parent) {
        Frame parentFrame = JOptionPane.getFrameForComponent(parent);
        DownloadMapDialog dia = new DownloadMapDialog(parentFrame);
        dia.pack();
        dia.setLocationRelativeTo(parentFrame);
        dia.setVisible(true);
    }

    public static void main(String[] args) {
        DownloadMapDialog.downloadGames(null);
    }
}

