/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.mc;

import games.strategy.engine.chat.ChatPanel;
import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.ClientGame;
import games.strategy.engine.framework.GameDataManager;
import games.strategy.engine.framework.GameObjectStreamFactory;
import games.strategy.engine.framework.message.PlayerListing;
import games.strategy.engine.framework.startup.launcher.IServerReady;
import games.strategy.engine.framework.startup.login.ClientLogin;
import games.strategy.engine.framework.startup.mc.ClientProps;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.IClientChannel;
import games.strategy.engine.framework.startup.mc.IObserverWaitingToJoin;
import games.strategy.engine.framework.startup.mc.IRemoteModelListener;
import games.strategy.engine.framework.startup.mc.IServerStartupRemote;
import games.strategy.engine.framework.startup.mc.ServerModel;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.ClientOptions;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.NewGameChooser;
import games.strategy.engine.framework.ui.background.WaitWindow;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.message.ChannelMessenger;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.RemoteMessenger;
import games.strategy.engine.message.RemoteName;
import games.strategy.engine.message.UnifiedMessenger;
import games.strategy.net.ClientMessenger;
import games.strategy.net.CouldNotLogInException;
import games.strategy.net.IMessenger;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.net.MacFinder;
import games.strategy.net.Messengers;
import games.strategy.ui.Util;
import games.strategy.util.EventThreadJOptionPane;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientModel
implements IMessengerErrorListener {
    public static final RemoteName CLIENT_READY_CHANNEL = new RemoteName("games.strategy.engine.framework.startup.mc.ClientModel.CLIENT_READY_CHANNEL", IServerReady.class);
    private static Logger s_logger = Logger.getLogger(ClientModel.class.getName());
    private IRemoteModelListener m_listener = IRemoteModelListener.NULL_LISTENER;
    private IChannelMessenger m_channelMessenger;
    private IRemoteMessenger m_remoteMessenger;
    private IMessenger m_messenger;
    private final GameObjectStreamFactory m_objectStreamFactory = new GameObjectStreamFactory(null);
    private final GameSelectorModel m_gameSelectorModel;
    private final SetupPanelModel m_typePanelModel;
    private Component m_ui;
    private ChatPanel m_chatPanel;
    private ClientGame m_game;
    private final WaitWindow m_gameLoadingWindow = new WaitWindow("Loading game, please wait.");
    private GameData m_gameDataOnStartup;
    private Map<String, String> m_players = new HashMap<String, String>();
    private Map<String, Collection<String>> m_playerNamesAndAlliancesInTurnOrder = new LinkedHashMap<String, Collection<String>>();
    private final IClientChannel m_channelListener = new IClientChannel(){

        @Override
        public void playerListingChanged(PlayerListing listing) {
            ClientModel.this.internalePlayerListingChanged(listing);
        }

        @Override
        public void gameReset() {
            ClientModel.this.m_objectStreamFactory.setData(null);
            Util.runInSwingEventThread(new Runnable(){

                public void run() {
                    MainFrame.getInstance().setVisible(true);
                }
            });
        }

        @Override
        public void doneSelectingPlayers(byte[] gameData, Map<String, INode> players) {
            CountDownLatch latch = new CountDownLatch(1);
            ClientModel.this.startGame(gameData, players, latch, false);
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    };
    IObserverWaitingToJoin m_observerWaitingToJoin = new IObserverWaitingToJoin(){

        @Override
        public void joinGame(byte[] gameData, Map<String, INode> players) {
            ClientModel.this.m_remoteMessenger.unregisterRemote(ServerModel.getObserverWaitingToStartName(ClientModel.this.m_messenger.getLocalNode()));
            CountDownLatch latch = new CountDownLatch(1);
            ClientModel.this.startGame(gameData, players, latch, true);
            try {
                latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void cannotJoinGame(final String reason) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientModel.this.m_typePanelModel.showSelectType();
                    EventThreadJOptionPane.showMessageDialog(ClientModel.this.m_ui, (Object)("Could not join game:" + reason));
                }
            });
        }
    };

    ClientModel(GameSelectorModel gameSelectorModel, SetupPanelModel typePanelModel) {
        this.m_typePanelModel = typePanelModel;
        this.m_gameSelectorModel = gameSelectorModel;
    }

    public void setRemoteModelListener(IRemoteModelListener listener) {
        if (listener == null) {
            listener = IRemoteModelListener.NULL_LISTENER;
        }
        this.m_listener = listener;
    }

    private ClientProps getProps(Component ui) {
        if (System.getProperties().getProperty("triplea.client", "false").equals("true") && System.getProperties().getProperty("triplea.started", "").equals("")) {
            ClientProps props = new ClientProps();
            props.setHost(System.getProperty("triplea.host"));
            props.setName(System.getProperty("triplea.name"));
            props.setPort(Integer.parseInt(System.getProperty("triplea.port")));
            System.setProperty("triplea.started", "true");
            return props;
        }
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String playername = prefs.get("PlayerName", System.getProperty("user.name"));
        ClientOptions options = new ClientOptions(ui, playername, 3300, "127.0.0.1");
        options.setLocationRelativeTo(ui);
        options.setVisible(true);
        options.dispose();
        if (!options.getOKPressed()) {
            return null;
        }
        ClientProps props = new ClientProps();
        props.setHost(options.getAddress());
        props.setName(options.getName());
        props.setPort(options.getPort());
        return props;
    }

    public boolean createClientMessenger(Component ui) {
        this.m_gameDataOnStartup = this.m_gameSelectorModel.getGameData();
        this.m_ui = ui = JOptionPane.getFrameForComponent(ui);
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        ClientProps props = this.getProps(ui);
        if (props == null) {
            return false;
        }
        String name = props.getName();
        s_logger.log(Level.FINE, "Client playing as:" + name);
        prefs.put("PlayerName", name);
        int port = props.getPort();
        if (port >= 65536 || port <= 0) {
            EventThreadJOptionPane.showMessageDialog(ui, "Invalid Port: " + port, "Error", 0);
            return false;
        }
        String address = props.getHost();
        try {
            String mac = MacFinder.GetHashedMacAddress();
            this.m_messenger = new ClientMessenger(address, port, name, mac, this.m_objectStreamFactory, new ClientLogin(this.m_ui));
        }
        catch (CouldNotLogInException ioe) {
            return false;
        }
        catch (Exception ioe) {
            ioe.printStackTrace(System.out);
            EventThreadJOptionPane.showMessageDialog(ui, "Unable to connect:" + ioe.getMessage(), "Error", 0);
            return false;
        }
        this.m_messenger.addErrorListener(this);
        UnifiedMessenger unifiedMessenger = new UnifiedMessenger(this.m_messenger);
        this.m_channelMessenger = new ChannelMessenger(unifiedMessenger);
        this.m_remoteMessenger = new RemoteMessenger(unifiedMessenger);
        this.m_channelMessenger.registerChannelSubscriber(this.m_channelListener, IClientChannel.CHANNEL_NAME);
        this.m_chatPanel = new ChatPanel(this.m_messenger, this.m_channelMessenger, this.m_remoteMessenger, "games.strategy.engine.framework.ui.ServerStartup.CHAT_NAME");
        this.m_remoteMessenger.registerRemote(this.m_observerWaitingToJoin, ServerModel.getObserverWaitingToStartName(this.m_messenger.getLocalNode()));
        this.m_gameDataOnStartup = this.m_gameSelectorModel.getGameData();
        IServerStartupRemote serverStartup = this.getServerStartup();
        PlayerListing players = serverStartup.getPlayerListing();
        this.internalePlayerListingChanged(players);
        if (!serverStartup.isGameStarted(this.m_messenger.getLocalNode())) {
            this.m_remoteMessenger.unregisterRemote(ServerModel.getObserverWaitingToStartName(this.m_messenger.getLocalNode()));
        }
        this.m_gameSelectorModel.setCanSelect(false);
        return true;
    }

    private IServerStartupRemote getServerStartup() {
        return (IServerStartupRemote)this.m_remoteMessenger.getRemote(ServerModel.SERVER_REMOTE_NAME);
    }

    public void cancel() {
        if (this.m_messenger == null) {
            return;
        }
        this.m_objectStreamFactory.setData(null);
        this.m_messenger.shutDown();
        this.m_chatPanel.setChat(null);
        this.m_gameSelectorModel.setGameData(this.m_gameDataOnStartup);
        this.m_gameSelectorModel.setCanSelect(true);
        this.m_messenger.removeErrorListener(this);
    }

    private void startGame(final byte[] gameData, final Map<String, INode> players, final CountDownLatch onDone, final boolean gameRunning) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClientModel.this.m_gameLoadingWindow.setVisible(true);
                ClientModel.this.m_gameLoadingWindow.setLocationRelativeTo(JOptionPane.getFrameForComponent(ClientModel.this.m_ui));
                ClientModel.this.m_gameLoadingWindow.showWait();
            }
        });
        Runnable r = new Runnable(){

            public void run() {
                try {
                    ClientModel.this.startGameInNewThread(gameData, players, gameRunning);
                }
                catch (RuntimeException e) {
                    ClientModel.this.m_gameLoadingWindow.doneWait();
                    throw e;
                }
                finally {
                    if (onDone != null) {
                        onDone.countDown();
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    private void startGameInNewThread(byte[] gameData, Map<String, INode> players, final boolean gameRunning) {
        GameData data;
        try {
            data = new GameDataManager().loadGame(new ByteArrayInputStream(gameData), null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        this.m_objectStreamFactory.setData(data);
        HashMap<String, String> playerMapping = new HashMap<String, String>();
        for (String player : this.m_players.keySet()) {
            String playedBy = this.m_players.get(player);
            if (!playedBy.equals(this.m_messenger.getLocalNode().getName())) continue;
            playerMapping.put(player, "Client");
        }
        final Set<IGamePlayer> playerSet = data.getGameLoader().createPlayers(playerMapping);
        Messengers messengers = new Messengers(this.m_messenger, this.m_remoteMessenger, this.m_channelMessenger);
        this.m_game = new ClientGame(data, playerSet, players, messengers);
        Thread t = new Thread("Client Game Launcher"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.getFrameForComponent(ClientModel.this.m_ui).setVisible(false);
                    }
                });
                try {
                    if (ClientModel.this.m_game != null) {
                        try {
                            data.getGameLoader().startGame(ClientModel.this.m_game, playerSet);
                            data.testLocksOnRead();
                            NewGameChooser.clearNewGameChooserModel();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ClientModel.this.m_messenger.shutDown();
                            ClientModel.this.m_gameLoadingWindow.doneWait();
                            MainFrame.getInstance().clientLeftGame();
                        }
                    }
                    if (!gameRunning) {
                        ((IServerReady)ClientModel.this.m_remoteMessenger.getRemote(CLIENT_READY_CHANNEL)).clientReady();
                    }
                }
                finally {
                    ClientModel.this.m_gameLoadingWindow.doneWait();
                }
            }
        };
        t.start();
    }

    public void takePlayer(String playerName) {
        this.getServerStartup().takePlayer(this.m_messenger.getLocalNode(), playerName);
    }

    public void releasePlayer(String playerName) {
        this.getServerStartup().releasePlayer(this.m_messenger.getLocalNode(), playerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalePlayerListingChanged(final PlayerListing listing) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClientModel.this.m_gameSelectorModel.clearDataButKeepGameInfo(listing.getGameName(), listing.getGameRound(), listing.getGameVersion().toString());
            }
        });
        ClientModel clientModel = this;
        synchronized (clientModel) {
            this.m_players = listing.getPlayerListing();
            this.m_playerNamesAndAlliancesInTurnOrder = listing.getPlayerNamesAndAlliancesInTurnOrderLinkedHashMap();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClientModel.this.m_listener.playerListChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPlayerMapping() {
        ClientModel clientModel = this;
        synchronized (clientModel) {
            return new HashMap<String, String>(this.m_players);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<String>> getPlayerNamesAndAlliancesInTurnOrderLinkedHashMap() {
        ClientModel clientModel = this;
        synchronized (clientModel) {
            return new LinkedHashMap<String, Collection<String>>(this.m_playerNamesAndAlliancesInTurnOrder);
        }
    }

    public IMessenger getMessenger() {
        return this.m_messenger;
    }

    private void connectionLost() {
        EventThreadJOptionPane.showMessageDialog(this.m_ui, " Connection To Server Lost", "Connection Lost", 0);
        if (this.m_game != null) {
            this.m_game.shutDown();
            this.m_game = null;
        }
        MainFrame.getInstance().clientLeftGame();
    }

    @Override
    public void messengerInvalid(IMessenger messenger, Exception reason) {
        this.connectionLost();
    }

    public ChatPanel getChatPanel() {
        return this.m_chatPanel;
    }
}

