/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.ProcessRunnerUtil;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.sound.SoundOptions;
import games.strategy.triplea.ui.TripleaMenu;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Triple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class EnginePreferences
extends JDialog {
    private static final long serialVersionUID = 5071190543005064757L;
    private final Frame m_parentFrame;
    private JButton m_okButton;
    private JButton m_lookAndFeel;
    private JButton m_gameParser;
    private JButton m_setupProxies;
    private JButton m_mapCreator;
    private JButton m_userFolder;
    private JButton m_programFolder;
    private JButton m_readme;
    private JButton m_donate;

    private EnginePreferences(Frame parentFrame) {
        super(parentFrame, "Edit TripleA Engine Preferences", true);
        this.m_parentFrame = parentFrame;
        this.createComponents();
        this.layoutCoponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                EnginePreferences.this.m_okButton.requestFocus();
            }
        });
    }

    private void createComponents() {
        this.m_okButton = new JButton("OK");
        this.m_lookAndFeel = new JButton("Set Look And Feel...");
        this.m_gameParser = new JButton("Enable/Disable Delayed Parsing of Game XML's");
        this.m_setupProxies = new JButton("Setup Network and Proxy Settings");
        this.m_mapCreator = new JButton("Run the Map Creator");
        this.m_userFolder = new JButton("Open User Maps and Savegames Folder");
        this.m_programFolder = new JButton("Open Installed Program Folder");
        this.m_readme = new JButton("Open Readme / User Manual");
        this.m_donate = new JButton("Donate...");
    }

    private void layoutCoponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        this.add((Component)buttonsPanel, "Center");
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(new JLabel("Change Engine Properties: "));
        buttonsPanel.add(new JLabel(" "));
        SoundOptions.addGlobalSoundSwitchCheckbox(buttonsPanel);
        buttonsPanel.add(new JLabel(" "));
        SoundOptions.addToPanel(buttonsPanel);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_lookAndFeel);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_gameParser);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_setupProxies);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_mapCreator);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_userFolder);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_programFolder);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_readme);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(this.m_donate);
        buttonsPanel.add(new JLabel(" "));
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel main = new JPanel();
        main.setBorder(new EmptyBorder(30, 30, 30, 30));
        main.setLayout(new BoxLayout(main, 0));
        main.add(this.m_okButton);
        this.add((Component)main, "South");
    }

    private void setupListeners() {
        this.m_okButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 8014389079875584858L;

            public void actionPerformed(ActionEvent e) {
                EnginePreferences.this.setVisible(false);
            }
        });
        this.m_lookAndFeel.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -6524988243523615143L;

            public void actionPerformed(ActionEvent event) {
                Triple<JList, Map<String, String>, String> lookAndFeel = TripleaMenu.getLookAndFeelList();
                JList list = (JList)lookAndFeel.getFirst();
                String currentKey = lookAndFeel.getThird();
                Map lookAndFeels = (Map)lookAndFeel.getSecond();
                if (JOptionPane.showConfirmDialog(EnginePreferences.this.m_parentFrame, list) == 0) {
                    String selectedValue = (String)list.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    if (selectedValue.equals(currentKey)) {
                        return;
                    }
                    GameRunner2.setDefaultLookAndFeel((String)lookAndFeels.get(selectedValue));
                    EventThreadJOptionPane.showMessageDialog(EnginePreferences.this.m_parentFrame, "The look and feel will update when you restart TripleA");
                }
            }
        });
        this.m_gameParser.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -6223524855968800051L;

            public void actionPerformed(ActionEvent e) {
                boolean delay;
                boolean current = GameRunner2.getDelayedParsing();
                Object[] options = new Object[]{"Parse Selected", "Parse All", "Cancel"};
                int answer = JOptionPane.showOptionDialog(EnginePreferences.this.m_parentFrame, new JLabel("<html>Delay Parsing of Game Data from XML until game is selected?<br><br>'" + options[1] + "' means each map is fully parsed as TripleA starts (useful for testing to make sure all your maps are valid)." + "<br><br>Your current setting is: '" + (current ? options[0].toString() : options[1].toString()) + "'</html>"), "Select Parsing Method", 1, 3, null, options, options[2]);
                if (answer == 2) {
                    return;
                }
                boolean bl = delay = answer == 0;
                if (delay == current) {
                    return;
                }
                GameRunner2.setDelayedParsing(delay);
                EventThreadJOptionPane.showMessageDialog(EnginePreferences.this.m_parentFrame, "Please restart TripleA to avoid any potential errors");
            }
        });
        this.m_setupProxies.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1673056396342959597L;

            public void actionPerformed(ActionEvent e) {
                Preferences pref = Preferences.userNodeForPackage(GameRunner2.class);
                GameRunner2.ProxyChoice proxyChoice = GameRunner2.ProxyChoice.valueOf(pref.get("proxy.choice", GameRunner2.ProxyChoice.NONE.toString()));
                String proxyHost = pref.get("proxy.host", "");
                JTextField hostText = new JTextField(proxyHost);
                String proxyPort = pref.get("proxy.port", "");
                JTextField portText = new JTextField(proxyPort);
                JRadioButton noneButton = new JRadioButton("None", proxyChoice == GameRunner2.ProxyChoice.NONE);
                JRadioButton systemButton = new JRadioButton("Use System Settings", proxyChoice == GameRunner2.ProxyChoice.USE_SYSTEM_SETTINGS);
                JRadioButton userButton = new JRadioButton("Use These User Settings:", proxyChoice == GameRunner2.ProxyChoice.USE_USER_PREFERENCES);
                ButtonGroup bgroup = new ButtonGroup();
                bgroup.add(noneButton);
                bgroup.add(systemButton);
                bgroup.add(userButton);
                JPanel radioPanel = new JPanel();
                radioPanel.setLayout(new BoxLayout(radioPanel, 1));
                radioPanel.add(new JLabel("Configure TripleA's Network and Proxy Settings: "));
                radioPanel.add(new JLabel("(This only effects Play-By-Forum games, dice servers, and map downloads.)"));
                radioPanel.add(noneButton);
                radioPanel.add(systemButton);
                radioPanel.add(userButton);
                radioPanel.add(new JLabel("Proxy Host: "));
                radioPanel.add(hostText);
                radioPanel.add(new JLabel("Proxy Port: "));
                radioPanel.add(portText);
                Object[] options = new Object[]{"Accept", "Cancel"};
                int answer = JOptionPane.showOptionDialog(EnginePreferences.this.m_parentFrame, radioPanel, "Network Settings", 2, 3, null, options, options[1]);
                if (answer != 0) {
                    return;
                }
                GameRunner2.ProxyChoice newChoice = systemButton.isSelected() ? GameRunner2.ProxyChoice.USE_SYSTEM_SETTINGS : (userButton.isSelected() ? GameRunner2.ProxyChoice.USE_USER_PREFERENCES : GameRunner2.ProxyChoice.NONE);
                GameRunner2.setProxy(hostText.getText(), portText.getText(), newChoice);
            }
        });
        this.m_mapCreator.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1262782772917758914L;

            public void actionPerformed(ActionEvent e) {
                ArrayList<String> commands = new ArrayList<String>();
                ProcessRunnerUtil.populateBasicJavaArgs(commands);
                String javaClass = "util.image.MapCreator";
                commands.add("util.image.MapCreator");
                ProcessRunnerUtil.exec(commands);
            }
        });
        this.m_userFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openFile(GameRunner.getUserRootFolder());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_programFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openFile(GameRunner.getRootFolder());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_readme.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openFile(new File(GameRunner.getRootFolder(), "readme.html"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_donate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("https://sourceforge.net/donate/index.php?group_id=44492");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void setWidgetActivation() {
    }

    public static void showEnginePreferences(JComponent parent) {
        Frame parentFrame = JOptionPane.getFrameForComponent(parent);
        EnginePreferences enginePrefs = new EnginePreferences(parentFrame);
        enginePrefs.pack();
        enginePrefs.setLocationRelativeTo(parentFrame);
        enginePrefs.setVisible(true);
    }

    public static void main(String[] args) {
        EnginePreferences.showEnginePreferences(null);
    }
}

