/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalPlayerComboBoxSelector {
    private final String m_playerName;
    private final JComboBox m_playerTypes;
    private final String m_playerAlliances;

    LocalPlayerComboBoxSelector(String playerName, Map<String, String> reloadSelections, Collection<String> playerAlliances, String[] types) {
        this.m_playerName = playerName;
        this.m_playerTypes = new JComboBox<String>(types);
        String previousSelection = reloadSelections.get(playerName);
        if (previousSelection.equalsIgnoreCase("Client")) {
            previousSelection = "Human";
        }
        if (!previousSelection.equals("no_one") && Arrays.asList(types).contains(previousSelection)) {
            this.m_playerTypes.setSelectedItem(previousSelection);
        } else if (this.m_playerName.startsWith("Neutral") || playerName.startsWith("AI")) {
            this.m_playerTypes.setSelectedItem("Moore N. Able (AI)");
        }
        this.m_playerAlliances = playerAlliances.contains(playerName) ? "" : playerAlliances.toString();
    }

    public void layout(int row, Container container) {
        container.add((Component)new JLabel(this.m_playerName + ":"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        container.add((Component)this.m_playerTypes, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        container.add((Component)new JLabel(this.m_playerAlliances.toString()), new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 5, 5), 0, 0));
    }

    public String getPlayerName() {
        return this.m_playerName;
    }

    public String getPlayerType() {
        return (String)this.m_playerTypes.getSelectedItem();
    }
}

