/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.startup.ui;

import games.strategy.engine.chat.ChatPanel;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.mc.SetupPanelModel;
import games.strategy.engine.framework.startup.ui.GameSelectorPanel;
import games.strategy.engine.framework.startup.ui.MetaSetupPanel;
import games.strategy.engine.framework.startup.ui.SetupPanel;
import games.strategy.triplea.ui.ErrorHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class MainPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -5548760379892913464L;
    private JScrollPane m_gameSetupPanelScroll;
    private GameSelectorPanel m_gameSelectorPanel;
    private JButton m_playButton;
    private JButton m_quitButton;
    private JButton m_cancelButton;
    private final GameSelectorModel m_gameSelectorModel;
    private SetupPanel m_gameSetupPanel;
    private JPanel m_gameSetupPanelHolder;
    private JPanel m_chatPanelHolder;
    private final SetupPanelModel m_gameTypePanelModel;
    private static final Dimension m_initialSize = GameRunner.isMac() ? new Dimension(685, 620) : new Dimension(625, 550);
    private boolean m_isChatShowing;

    public MainPanel(SetupPanelModel typePanelModel) {
        this.m_gameTypePanelModel = typePanelModel;
        this.m_gameSelectorModel = typePanelModel.getGameSelectorModel();
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
        if (typePanelModel.getPanel() != null) {
            this.setGameSetupPanel(typePanelModel.getPanel());
        }
    }

    JButton getDefaultButton() {
        return this.m_playButton;
    }

    private void createComponents() {
        this.m_playButton = new JButton("Play");
        this.m_playButton.setToolTipText("<html>Start your game! <br>If not enabled, then you must select a way to play your game first: <br>Play Online, or Local Game, or PBEM, or Host Networked.</html>");
        this.m_quitButton = new JButton("Quit");
        this.m_quitButton.setToolTipText("Close TripleA.");
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.setToolTipText("Go back to main screen.");
        this.m_gameSelectorPanel = new GameSelectorPanel(this.m_gameSelectorModel);
        this.m_gameSelectorPanel.setBorder(new EtchedBorder());
        this.m_gameSetupPanelHolder = new JPanel();
        this.m_gameSetupPanelHolder.setLayout(new BorderLayout());
        this.m_gameSetupPanelScroll = new JScrollPane(this.m_gameSetupPanelHolder);
        this.m_gameSetupPanelScroll.setBorder(BorderFactory.createEmptyBorder());
        this.m_chatPanelHolder = new JPanel();
        this.m_chatPanelHolder.setLayout(new BorderLayout());
    }

    private void layoutComponents() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(new EtchedBorder());
        buttonsPanel.setLayout(new FlowLayout(1));
        buttonsPanel.add(this.m_playButton);
        buttonsPanel.add(this.m_quitButton);
        this.setLayout(new GridBagLayout());
        this.m_gameSetupPanelHolder.setLayout(new BorderLayout());
        this.add((Component)this.m_gameSelectorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_gameSetupPanelScroll, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addChat();
        this.add((Component)buttonsPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setPreferredSize(m_initialSize);
    }

    private void addChat() {
        this.m_chatPanelHolder.removeAll();
        this.remove(this.m_chatPanelHolder);
        ChatPanel chat = this.m_gameTypePanelModel.getPanel().getChatPanel();
        if (chat != null) {
            this.m_chatPanelHolder = new JPanel();
            this.m_chatPanelHolder.setLayout(new BorderLayout());
            this.m_chatPanelHolder.add((Component)chat, "Center");
            this.add((Component)this.m_chatPanelHolder, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.2, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.m_isChatShowing = chat != null;
    }

    public void setGameSetupPanel(SetupPanel panel) {
        boolean panelHasChat;
        if (this.m_gameSetupPanel != null) {
            this.m_gameSetupPanel.removeObserver(this);
            this.m_gameSetupPanelHolder.remove(panel);
        }
        this.m_gameSetupPanel = panel;
        this.m_gameSetupPanelHolder.removeAll();
        this.m_gameSetupPanelHolder.add((Component)panel, "Center");
        panel.addObserver(this);
        this.setWidgetActivation();
        if (!(panel instanceof MetaSetupPanel)) {
            JPanel cancelPanel = new JPanel();
            cancelPanel.setBorder(new EmptyBorder(10, 0, 10, 10));
            cancelPanel.setLayout(new FlowLayout(2));
            this.createUserActionMenu(cancelPanel);
            cancelPanel.add(this.m_cancelButton);
            this.m_gameSetupPanelHolder.add((Component)cancelPanel, "South");
        }
        boolean bl = panelHasChat = this.m_gameTypePanelModel.getPanel().getChatPanel() != null;
        if (panelHasChat != this.m_isChatShowing) {
            this.addChat();
        }
        this.invalidate();
        this.revalidate();
    }

    private void createUserActionMenu(JPanel cancelPanel) {
        if (this.m_gameSetupPanel.getUserActions() == null) {
            return;
        }
        final JButton button = new JButton("Network...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                List<Action> actions = MainPanel.this.m_gameSetupPanel.getUserActions();
                if (actions != null && !actions.isEmpty()) {
                    for (Action a : actions) {
                        menu.add(a);
                    }
                }
                menu.show(button, 0, button.getHeight());
            }
        });
        cancelPanel.add(button);
    }

    private void setupListeners() {
        this.m_gameTypePanelModel.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                MainPanel.this.setGameSetupPanel(MainPanel.this.m_gameTypePanelModel.getPanel());
            }
        });
        this.m_playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.play();
            }
        });
        this.m_quitButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                try {
                    MainPanel.this.m_gameSetupPanel.cancel();
                }
                finally {
                    System.exit(0);
                }
            }
        });
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPanel.this.m_gameTypePanelModel.showSelectType();
            }
        });
        this.m_gameSelectorModel.addObserver(this);
    }

    private void play() {
        ErrorHandler.setGameOver(false);
        this.m_gameSetupPanel.preStartGame();
        this.m_gameTypePanelModel.getPanel().getLauncher().launch(this);
        this.m_gameSetupPanel.postStartGame();
    }

    private void setWidgetActivation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainPanel.this.setWidgetActivation();
                }
            });
            return;
        }
        this.m_gameTypePanelModel.setWidgetActivation();
        if (this.m_gameSetupPanel != null) {
            this.m_playButton.setEnabled(this.m_gameSetupPanel.canGameStart());
        } else {
            this.m_playButton.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        GameSelectorModel gameSelectorModel = new GameSelectorModel();
        SetupPanelModel model = new SetupPanelModel(gameSelectorModel);
        model.showSelectType();
        f.getContentPane().add(new MainPanel(model));
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public void update(Observable o, Object arg) {
        this.setWidgetActivation();
    }
}

