/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.ui.NewGameChooserEntry;
import games.strategy.engine.framework.ui.NewGameChooserModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NewGameChooser
extends JDialog {
    private static final long serialVersionUID = -3223711652118741132L;
    private static NewGameChooserModel s_cachedGameModel = null;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private JButton m_refreshGamesButton;
    private JList m_gameList;
    private JPanel m_infoPanel;
    private JEditorPane m_notesPanel;
    private NewGameChooserModel m_gameListModel;
    private NewGameChooserEntry m_choosen;

    private NewGameChooser(Frame owner) {
        super(owner, "Select a Game", true);
        this.createComponents();
        this.layoutCoponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.updateInfoPanel();
    }

    private void createComponents() {
        this.m_okButton = new JButton("OK");
        this.m_cancelButton = new JButton("Cancel");
        this.m_refreshGamesButton = new JButton("Refresh Game List");
        this.m_gameListModel = NewGameChooser.getNewGameChooserModel();
        this.m_gameList = new JList(this.m_gameListModel);
        this.m_infoPanel = new JPanel();
        this.m_infoPanel.setLayout(new BorderLayout());
        this.m_notesPanel = new JEditorPane();
        this.m_notesPanel.setEditable(false);
        this.m_notesPanel.setContentType("text/html");
        this.m_notesPanel.setBackground(new JLabel().getBackground());
    }

    private void layoutCoponents() {
        this.setLayout(new BorderLayout());
        JSplitPane mainSplit = new JSplitPane();
        this.add((Component)mainSplit, "Center");
        JScrollPane listScroll = new JScrollPane();
        listScroll.setBorder(null);
        listScroll.getViewport().setBorder(null);
        listScroll.setViewportView(this.m_gameList);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        JLabel gamesLabel = new JLabel("Games");
        gamesLabel.setFont(gamesLabel.getFont().deriveFont(1, gamesLabel.getFont().getSize() + 2));
        leftPanel.add((Component)gamesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        leftPanel.add((Component)listScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        mainSplit.setLeftComponent(leftPanel);
        mainSplit.setRightComponent(this.m_infoPanel);
        mainSplit.setBorder(null);
        listScroll.setMinimumSize(new Dimension(200, 0));
        JPanel buttonsPanel = new JPanel();
        this.add((Component)buttonsPanel, "South");
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalStrut(30));
        buttonsPanel.add(this.m_refreshGamesButton);
        buttonsPanel.add(Box.createGlue());
        buttonsPanel.add(this.m_okButton);
        buttonsPanel.add(this.m_cancelButton);
        buttonsPanel.add(Box.createGlue());
        JScrollPane notesScroll = new JScrollPane();
        notesScroll.setViewportView(this.m_notesPanel);
        notesScroll.setBorder(null);
        notesScroll.getViewport().setBorder(null);
        this.m_infoPanel.add(Box.createVerticalStrut(10), "North");
        this.m_infoPanel.add(Box.createHorizontalStrut(10), "West");
        this.m_infoPanel.add((Component)notesScroll, "Center");
    }

    public static NewGameChooserEntry chooseGame(Frame parent, String defaultGameName) {
        NewGameChooser chooser = new NewGameChooser(parent);
        chooser.setSize(800, 600);
        chooser.setLocationRelativeTo(parent);
        if (defaultGameName != null) {
            chooser.selectGame(defaultGameName);
        }
        chooser.setVisible(true);
        NewGameChooserEntry choosen = chooser.m_choosen;
        chooser.setVisible(false);
        chooser.dispose();
        return choosen;
    }

    private void selectGame(String gameName) {
        if (gameName == null) {
            return;
        }
        NewGameChooserEntry entry = this.m_gameListModel.findByName(gameName);
        if (entry != null) {
            this.m_gameList.setSelectedValue(entry, true);
        }
    }

    private void updateInfoPanel() {
        if (this.getSelected() != null) {
            GameData data = this.getSelected().getGameData();
            StringBuilder notes = new StringBuilder();
            notes.append("<h1>").append(data.getGameName()).append("</h1>");
            this.appendListItem("Map Name", data.getProperties().get("mapName", ""), notes);
            this.appendListItem("Number Of Players", data.getPlayerList().size() + "", notes);
            this.appendListItem("Location", this.getSelected().getLocation() + "", notes);
            this.appendListItem("Version", data.getGameVersion() + "", notes);
            notes.append("<p></p>");
            notes.append(data.getProperties().get("notes", ""));
            this.m_notesPanel.setText(notes.toString());
        } else {
            this.m_notesPanel.setText("");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NewGameChooser.this.m_notesPanel.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            }
        });
    }

    private void appendListItem(String title, String value, StringBuilder builder) {
        builder.append("<b>").append(title).append("</b>").append(": ").append(value).append("<br>");
    }

    private NewGameChooserEntry getSelected() {
        int selected = this.m_gameList.getSelectedIndex();
        if (selected == -1) {
            return null;
        }
        return this.m_gameListModel.get(selected);
    }

    private void setWidgetActivation() {
    }

    private void setupListeners() {
        this.m_refreshGamesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewGameChooser.this.refreshGameList();
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewGameChooser.this.selectAndReturn();
            }
        });
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewGameChooser.this.cancelAndReturn();
            }
        });
        this.m_gameList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                NewGameChooser.this.updateInfoPanel();
            }
        });
        this.m_gameList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    NewGameChooser.this.selectAndReturn();
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public static synchronized NewGameChooserModel getNewGameChooserModel() {
        if (s_cachedGameModel == null) {
            NewGameChooser.refreshNewGameChooserModel();
        }
        return s_cachedGameModel;
    }

    public static synchronized void refreshNewGameChooserModel() {
        NewGameChooser.clearNewGameChooserModel();
        s_cachedGameModel = new NewGameChooserModel();
    }

    public static synchronized void clearNewGameChooserModel() {
        if (s_cachedGameModel != null) {
            s_cachedGameModel.clear();
            s_cachedGameModel = null;
        }
    }

    private void refreshGameList() {
        this.m_gameList.setEnabled(false);
        final NewGameChooserEntry selected = this.getSelected();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    NewGameChooser.refreshNewGameChooserModel();
                    NewGameChooser.this.m_gameListModel = NewGameChooser.getNewGameChooserModel();
                    NewGameChooser.this.m_gameList.setModel(NewGameChooser.this.m_gameListModel);
                    if (selected != null) {
                        String name = selected.getGameData().getGameName();
                        NewGameChooserEntry found = NewGameChooser.this.m_gameListModel.findByName(name);
                        if (name != null) {
                            NewGameChooser.this.m_gameList.setSelectedValue(found, true);
                        }
                    }
                }
                finally {
                    NewGameChooser.this.m_gameList.setEnabled(true);
                }
            }
        });
    }

    private void selectAndReturn() {
        this.m_choosen = this.getSelected();
        this.setVisible(false);
    }

    private void cancelAndReturn() {
        this.m_choosen = null;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        NewGameChooser.chooseGame(null, "Revised");
        System.exit(0);
    }
}

