/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.framework.ui;

import games.strategy.engine.data.EngineVersionException;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameParseException;
import games.strategy.engine.data.GameParser;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.GameRunner2;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NewGameChooserEntry {
    private final URI m_url;
    private GameData m_data;
    private boolean m_gameDataFullyLoaded = false;
    private final String m_gameNameAndMapNameProperty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewGameChooserEntry(URI uri) throws IOException, GameParseException, SAXException, EngineVersionException {
        this.m_url = uri;
        InputStream input = uri.toURL().openStream();
        boolean delayParsing = GameRunner2.getDelayedParsing();
        try {
            this.m_data = new GameParser().parse(input, delayParsing);
            this.m_gameDataFullyLoaded = !delayParsing;
            this.m_gameNameAndMapNameProperty = this.getGameName() + ":" + this.getMapNameProperty();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyParseGameData() throws GameParseException {
        this.m_data = null;
        String error = null;
        try {
            InputStream input = this.m_url.toURL().openStream();
            try {
                this.m_data = new GameParser().parse(input, false);
                this.m_gameDataFullyLoaded = true;
            }
            catch (EngineVersionException e) {
                System.out.println(e.getMessage());
                error = e.getMessage();
            }
            catch (SAXParseException e) {
                System.err.println("Could not parse:" + this.m_url + " error at line:" + e.getLineNumber() + " column:" + e.getColumnNumber());
                e.printStackTrace();
                error = e.getMessage();
            }
            catch (Exception e) {
                System.err.println("Could not parse:" + this.m_url);
                e.printStackTrace();
                error = e.getMessage();
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            error = e1.getMessage();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            error = e1.getMessage();
        }
        if (error != null) {
            throw new GameParseException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayParseGameData() {
        this.m_data = null;
        try {
            InputStream input = this.m_url.toURL().openStream();
            try {
                this.m_data = new GameParser().parse(input, true);
                this.m_gameDataFullyLoaded = false;
            }
            catch (EngineVersionException e) {
                System.out.println(e.getMessage());
            }
            catch (SAXParseException e) {
                System.err.println("Could not parse:" + this.m_url + " error at line:" + e.getLineNumber() + " column:" + e.getColumnNumber());
                e.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("Could not parse:" + this.m_url);
                e.printStackTrace();
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public boolean isGameDataLoaded() {
        return this.m_gameDataFullyLoaded;
    }

    public String getGameName() {
        return this.m_data.getGameName();
    }

    private String getMapNameProperty() {
        String mapName = (String)this.m_data.getProperties().get("mapName");
        if (mapName == null || mapName.trim().length() == 0) {
            throw new IllegalStateException("Map name property not set on game");
        }
        return mapName;
    }

    public String getGameNameAndMapNameProperty() {
        return this.m_gameNameAndMapNameProperty;
    }

    public String toString() {
        return this.getGameName();
    }

    public GameData getGameData() {
        return this.m_data;
    }

    public URI getURI() {
        return this.m_url;
    }

    public String getLocation() {
        String base;
        String raw = this.m_url.toString();
        if (raw.startsWith(base = GameRunner.getRootFolder().toURI().toString() + "maps")) {
            return raw.substring(base.length());
        }
        if (raw.startsWith("jar:" + base)) {
            return raw.substring("jar:".length() + base.length());
        }
        return raw;
    }

    public int hashCode() {
        return this.getGameNameAndMapNameProperty().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NewGameChooserEntry other = (NewGameChooserEntry)obj;
        if (this.m_data == null ? other.m_data != null : other.m_data == null) {
            return false;
        }
        return this.getGameNameAndMapNameProperty().equals(other.getGameNameAndMapNameProperty());
    }
}

