/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client;

import games.strategy.debug.HeartBeat;
import games.strategy.engine.lobby.server.IModeratorController;
import games.strategy.engine.lobby.server.ModeratorController;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.net.IMessenger;
import games.strategy.net.Messengers;

public class LobbyClient {
    private final Messengers m_messengers;
    private final boolean m_isAnonymousLogin;
    private Boolean isAdmin;

    public LobbyClient(IMessenger messenger, boolean anonymousLogin) {
        this.m_messengers = new Messengers(messenger);
        this.m_isAnonymousLogin = anonymousLogin;
        HeartBeat heartBeatServer = new HeartBeat(this.m_messengers.getMessenger().getServerNode());
        this.m_messengers.getRemoteMessenger().registerRemote(heartBeatServer, HeartBeat.getHeartBeatName(this.m_messengers.getMessenger().getLocalNode()));
    }

    public boolean isAdmin() {
        if (this.isAdmin == null) {
            IModeratorController controller = (IModeratorController)this.m_messengers.getRemoteMessenger().getRemote(ModeratorController.getModeratorControllerName());
            this.isAdmin = controller.isAdmin();
        }
        return this.isAdmin;
    }

    public boolean isAnonymousLogin() {
        return this.m_isAnonymousLogin;
    }

    public IChannelMessenger getChannelMessenger() {
        return this.m_messengers.getChannelMessenger();
    }

    public IMessenger getMessenger() {
        return this.m_messengers.getMessenger();
    }

    public IRemoteMessenger getRemoteMessenger() {
        return this.m_messengers.getRemoteMessenger();
    }

    public Messengers getMessengers() {
        return this.m_messengers;
    }
}

