/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.client.ui;

import games.strategy.engine.lobby.server.GameDescription;
import games.strategy.engine.lobby.server.ILobbyGameBroadcaster;
import games.strategy.engine.lobby.server.ILobbyGameController;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.engine.message.MessageContext;
import games.strategy.net.GUID;
import games.strategy.net.IMessenger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LobbyGameTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 6399458368730633993L;
    private final IMessenger m_messenger;
    private final IChannelMessenger m_channelMessenger;
    private final IRemoteMessenger m_remoteMessenger;
    private final List<GUID> m_gameIDs = new ArrayList<GUID>();
    private final List<GameDescription> m_games = new ArrayList<GameDescription>();

    public LobbyGameTableModel(IMessenger messenger, IChannelMessenger channelMessenger, IRemoteMessenger remoteMessenger) {
        this.m_messenger = messenger;
        this.m_channelMessenger = channelMessenger;
        this.m_remoteMessenger = remoteMessenger;
        this.m_channelMessenger.registerChannelSubscriber(new ILobbyGameBroadcaster(){

            public void gameUpdated(GUID gameId, GameDescription description) {
                LobbyGameTableModel.this.assertSentFromServer();
                LobbyGameTableModel.this.updateGame(gameId, description);
            }

            public void gameAdded(GUID gameId, GameDescription description) {
                LobbyGameTableModel.this.assertSentFromServer();
                LobbyGameTableModel.this.addGame(gameId, description);
            }

            public void gameRemoved(GUID gameId) {
                LobbyGameTableModel.this.assertSentFromServer();
                LobbyGameTableModel.this.removeGame(gameId);
            }
        }, ILobbyGameBroadcaster.GAME_BROADCASTER_CHANNEL);
        Map<GUID, GameDescription> games = ((ILobbyGameController)this.m_remoteMessenger.getRemote(ILobbyGameController.GAME_CONTROLLER_REMOTE)).listGames();
        for (GUID id : games.keySet()) {
            this.addGame(id, games.get(id));
        }
    }

    public GameDescription get(int i) {
        return this.m_games.get(i);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.getColumnIndex(Column.Started)) {
            return Date.class;
        }
        return Object.class;
    }

    private void removeGame(final GUID gameId) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int index = LobbyGameTableModel.this.m_gameIDs.indexOf(gameId);
                LobbyGameTableModel.this.m_gameIDs.remove(index);
                LobbyGameTableModel.this.m_games.remove(index);
                LobbyGameTableModel.this.fireTableRowsDeleted(index, index);
            }
        });
    }

    private void addGame(final GUID gameId, final GameDescription description) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LobbyGameTableModel.this.m_gameIDs.add(gameId);
                LobbyGameTableModel.this.m_games.add(description);
                LobbyGameTableModel.this.fireTableRowsInserted(LobbyGameTableModel.this.m_gameIDs.size() - 1, LobbyGameTableModel.this.m_gameIDs.size() - 1);
            }
        });
    }

    private void assertSentFromServer() {
        if (!MessageContext.getSender().equals(this.m_messenger.getServerNode())) {
            throw new IllegalStateException("Invalid sender");
        }
    }

    private void updateGame(final GUID gameId, final GameDescription description) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int index = LobbyGameTableModel.this.m_gameIDs.indexOf(gameId);
                LobbyGameTableModel.this.m_games.set(index, description);
                LobbyGameTableModel.this.fireTableRowsUpdated(index, index);
            }
        });
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].toString();
    }

    public int getColumnIndex(Column column) {
        return column.ordinal();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length - 1;
    }

    @Override
    public int getRowCount() {
        return this.m_gameIDs.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Column column = Column.values()[columnIndex];
        GameDescription description = this.m_games.get(rowIndex);
        switch (column) {
            case Host: {
                return description.getHostName();
            }
            case Round: {
                return description.getRound();
            }
            case Name: {
                return description.getGameName();
            }
            case Players: {
                return description.getPlayerCount();
            }
            case PW: {
                return description.getPassworded() ? "Y" : "";
            }
            case GV: {
                return description.getGameVersion();
            }
            case EV: {
                return description.getEngineVersion();
            }
            case Status: {
                return description.getStatus();
            }
            case Comments: {
                return description.getComment();
            }
            case Started: {
                return description.getStartDateTime();
            }
            case GUID: {
                return this.m_gameIDs.get(rowIndex);
            }
        }
        throw new IllegalStateException("Unknown column:" + (Object)((Object)column));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Column {
        Host,
        Name,
        GV,
        Round,
        Players,
        PW,
        EV,
        Started,
        Status,
        Comments,
        GUID;

    }
}

