/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server;

import games.strategy.net.INode;
import games.strategy.net.Node;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;

public class GameDescription
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 508593169141567546L;
    private INode m_hostedBy;
    private int m_port;
    private Date m_startDateTime;
    private String m_gameName;
    private int m_playerCount;
    private String m_round;
    private GameStatus m_status;
    private int m_version = Integer.MIN_VALUE;
    private String m_hostName;
    private String m_comment;
    private boolean m_passworded;
    private String m_engineVersion;
    private String m_gameVersion;

    public GameDescription() {
    }

    public GameDescription(INode hostedBy, int port, Date startDateTime, String gameName, int playerCount, GameStatus status, String round, String hostName, String comment, boolean passworded, String engineVersion, String gameVersion) {
        this.m_hostName = hostName;
        this.m_hostedBy = hostedBy;
        this.m_port = port;
        this.m_startDateTime = startDateTime;
        this.m_gameName = gameName;
        this.m_playerCount = playerCount;
        this.m_status = status;
        this.m_round = round;
        this.m_comment = comment;
        this.m_passworded = passworded;
        this.m_engineVersion = engineVersion;
        this.m_gameVersion = gameVersion;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("how did that happen");
        }
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setGameName(String gameName) {
        ++this.m_version;
        this.m_gameName = gameName;
    }

    public void setHostedBy(INode hostedBy) {
        ++this.m_version;
        this.m_hostedBy = hostedBy;
    }

    public void setPlayerCount(int playerCount) {
        ++this.m_version;
        this.m_playerCount = playerCount;
    }

    public void setPort(int port) {
        ++this.m_version;
        this.m_port = port;
    }

    public void setRound(String round) {
        ++this.m_version;
        this.m_round = round;
    }

    public void setStartDateTime(Date startDateTime) {
        ++this.m_version;
        this.m_startDateTime = startDateTime;
    }

    public void setStatus(GameStatus status) {
        ++this.m_version;
        this.m_status = status;
    }

    public void setPassworded(boolean passworded) {
        ++this.m_version;
        this.m_passworded = passworded;
    }

    public boolean getPassworded() {
        return this.m_passworded;
    }

    public void setEngineVersion(String engineVersion) {
        ++this.m_version;
        this.m_engineVersion = engineVersion;
    }

    public void setGameVersion(String gameVersion) {
        ++this.m_version;
        this.m_gameVersion = gameVersion;
    }

    public String getEngineVersion() {
        return this.m_engineVersion;
    }

    public String getGameVersion() {
        return this.m_gameVersion;
    }

    public String getRound() {
        return this.m_round;
    }

    public String getGameName() {
        return this.m_gameName;
    }

    public INode getHostedBy() {
        return this.m_hostedBy;
    }

    public int getPlayerCount() {
        return this.m_playerCount;
    }

    public int getPort() {
        return this.m_port;
    }

    public Date getStartDateTime() {
        return this.m_startDateTime;
    }

    public GameStatus getStatus() {
        return this.m_status;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public void setHostName(String hostName) {
        ++this.m_version;
        this.m_hostName = hostName;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        ++this.m_version;
        this.m_comment = comment;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_hostedBy = new Node();
        ((Node)this.m_hostedBy).readExternal(in);
        this.m_port = in.readInt();
        this.m_startDateTime = new Date();
        this.m_startDateTime.setTime(in.readLong());
        this.m_playerCount = in.readByte();
        this.m_round = in.readUTF();
        this.m_status = GameStatus.values()[in.readByte()];
        this.m_version = in.readInt();
        this.m_hostName = in.readUTF();
        this.m_comment = in.readUTF();
        this.m_gameName = in.readUTF();
        this.m_passworded = in.readBoolean();
        this.m_engineVersion = in.readUTF();
        this.m_gameVersion = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        ((Node)this.m_hostedBy).writeExternal(out);
        out.writeInt(this.m_port);
        out.writeLong(this.m_startDateTime.getTime());
        out.writeByte(this.m_playerCount);
        out.writeUTF(this.m_round);
        out.writeByte(this.m_status.ordinal());
        out.writeInt(this.m_version);
        out.writeUTF(this.m_hostName);
        out.writeUTF(this.m_comment);
        out.writeUTF(this.m_gameName);
        out.writeBoolean(this.m_passworded);
        out.writeUTF(this.m_engineVersion);
        out.writeUTF(this.m_gameVersion);
    }

    public String toString() {
        return "Game Hosted By:" + this.m_hostName + " gameName:" + this.m_gameName + " at:" + this.m_hostedBy.getAddress() + ":" + this.m_port + " playerCount:" + this.m_playerCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameStatus {
        LAUNCHING{

            public String toString() {
                return "Launching";
            }
        }
        ,
        IN_PROGRESS{

            public String toString() {
                return "In Progress";
            }
        }
        ,
        WAITING_FOR_PLAYERS{

            public String toString() {
                return "Waiting For Players";
            }
        };

    }
}

