/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.headless;

import games.strategy.debug.Console;
import games.strategy.engine.lobby.server.LobbyServer;
import games.strategy.engine.lobby.server.ui.DBExplorerPanel;
import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.INode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicInteger;

public class HeadlessLobbyConsole {
    private final LobbyServer server;
    private final PrintStream out;
    private final BufferedReader in;
    private final String startDate = new Date().toGMTString();
    private final AtomicInteger totalLogins = new AtomicInteger();
    private final AtomicInteger currentConnections = new AtomicInteger();
    private volatile int maxConcurrentLogins = 0;

    public HeadlessLobbyConsole(LobbyServer server, InputStream in, PrintStream out) {
        this.out = out;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.server = server;
        server.getMessenger().addConnectionChangeListener(new IConnectionChangeListener(){

            public void connectionAdded(INode to) {
                HeadlessLobbyConsole.this.currentConnections.incrementAndGet();
                HeadlessLobbyConsole.this.totalLogins.incrementAndGet();
                HeadlessLobbyConsole.this.maxConcurrentLogins = Math.max(HeadlessLobbyConsole.this.maxConcurrentLogins, HeadlessLobbyConsole.this.currentConnections.get());
            }

            public void connectionRemoved(INode to) {
                HeadlessLobbyConsole.this.currentConnections.decrementAndGet();
            }
        });
    }

    public void start() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                HeadlessLobbyConsole.this.printEvalLoop();
            }
        }, "Headless console eval print loop");
        t.start();
    }

    private void printEvalLoop() {
        this.out.println();
        while (true) {
            this.out.print(">>>>");
            this.out.flush();
            try {
                String command = this.in.readLine();
                this.process(command.trim());
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                t.printStackTrace(this.out);
                continue;
            }
            break;
        }
    }

    private void process(String command) {
        if (command.equals("")) {
            return;
        }
        String noun = command.split("\\s")[0];
        if (noun.equals("help")) {
            this.showHelp();
        } else if (noun.equals("status")) {
            this.showStatus();
        } else if (noun.equals("sql")) {
            this.executeSql(command.substring("sql".length(), command.length()).trim());
        } else if (noun.equals("quit")) {
            this.quit();
        } else if (noun.equals("backup")) {
            this.backup();
        } else if (noun.equals("memory")) {
            this.memory();
        } else if (noun.equals("threads")) {
            this.threads();
        } else {
            this.out.println("unrecognized command:" + command);
            this.showHelp();
        }
    }

    private void threads() {
        this.out.println(Console.getThreadDumps());
    }

    private void memory() {
        this.out.println(Console.getMemory());
    }

    private void backup() {
        Database.backup();
    }

    private void quit() {
        this.out.println("Are you sure? (y/n)");
        try {
            if (this.in.readLine().toLowerCase().startsWith("y")) {
                System.exit(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String sql) {
        Connection con = Database.getConnection();
        try {
            Statement ps = con.createStatement();
            if (DBExplorerPanel.isNotQuery(sql)) {
                int rs = ps.executeUpdate(sql);
                this.out.println("Update count:" + rs);
            } else {
                ResultSet rs = ps.executeQuery(sql);
                this.print(rs);
                rs.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            this.out.println(sqle.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void print(ResultSet rs) {
        try {
            int i;
            Formatter f = new Formatter(this.out);
            String itemFormat = "%20s ";
            f.format("%20s ", "Count");
            int count = rs.getMetaData().getColumnCount();
            for (i = 1; i <= count; ++i) {
                String columnName = rs.getMetaData().getColumnName(i);
                f.format("%20s ", columnName);
            }
            f.format("\n", new Object[0]);
            for (i = 0; i < count; ++i) {
                f.format("%20s ", "-----------");
            }
            f.format("\n", new Object[0]);
            int row = 1;
            while (rs.next()) {
                f.format("%20s ", row++);
                for (int i2 = 1; i2 <= count; ++i2) {
                    f.format("%20s ", rs.getString(i2));
                }
                f.format("\n", new Object[0]);
                f.flush();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(this.out);
        }
    }

    private void showStatus() {
        int port = this.server.getMessenger().getServerNode().getPort();
        this.out.print(String.format("port:%s\nup since:%s\ntotal logins:%s\ncurrent connections:%s\nmax concurrent connections:%s\n", port, this.startDate, this.totalLogins.get(), this.currentConnections.get(), this.maxConcurrentLogins));
    }

    private void showHelp() {
        this.out.println("available commands:\n  backup - backup the database \n  help - show this message\n  memory - show memory usage\n  status - show status information\n  sql {sql} - execute a sql command and print the results\n  threads - get thread dumps\n  quit - quit\n");
    }
}

