/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.ui;

import games.strategy.engine.lobby.server.ui.LobbyAdminStatPanel;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class AllUsersPanel
extends JPanel {
    private static final long serialVersionUID = -9133556462653843231L;
    private final IMessenger m_messenger;
    private JList m_nodes;
    private DefaultListModel m_nodesModel;
    private LobbyAdminStatPanel m_statPane;
    private final List<INode> m_orderedNodes;

    public AllUsersPanel(IMessenger messenger) {
        this.m_messenger = messenger;
        this.m_orderedNodes = new ArrayList<INode>();
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_nodesModel = new DefaultListModel();
        this.m_nodes = new JList(this.m_nodesModel);
        this.m_statPane = new LobbyAdminStatPanel(this.m_messenger);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_nodes), "Center");
        this.add((Component)this.m_statPane, "South");
    }

    private void setupListeners() {
        ((IServerMessenger)this.m_messenger).addConnectionChangeListener(new IConnectionChangeListener(){

            public void connectionRemoved(final INode to) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AllUsersPanel.this.m_orderedNodes.remove(to);
                        AllUsersPanel.this.refreshModel();
                    }
                });
            }

            public void connectionAdded(final INode to) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AllUsersPanel.this.m_orderedNodes.add(to);
                        AllUsersPanel.this.refreshModel();
                    }
                });
            }
        });
    }

    private void refreshModel() {
        Collections.sort(this.m_orderedNodes);
        this.m_nodesModel.clear();
        for (INode node : this.m_orderedNodes) {
            this.m_nodesModel.addElement(node);
        }
    }

    private void setWidgetActivation() {
    }
}

