/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.ui;

import games.strategy.debug.HeartBeat;
import games.strategy.debug.IHeartBeat;
import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.ChatMessagePanel;
import games.strategy.engine.framework.networkMaintenance.BootPlayerAction;
import games.strategy.engine.lobby.client.ui.LobbyGamePanel;
import games.strategy.engine.lobby.server.LobbyServer;
import games.strategy.engine.lobby.server.ui.AllUsersPanel;
import games.strategy.engine.lobby.server.ui.DBExplorerPanel;
import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.message.RemoteName;
import games.strategy.net.INode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class LobbyAdminConsole
extends JFrame {
    private static final long serialVersionUID = -3982159130973521505L;
    private static final Logger s_logger = Logger.getLogger(LobbyAdminConsole.class.getName());
    private final LobbyServer m_server;
    private JButton m_backupNow;
    private JButton m_exit;
    private JButton m_bootPlayer;
    private JButton m_debugPlayer;
    private DBExplorerPanel m_executor;
    private AllUsersPanel m_allUsers;
    private LobbyGamePanel m_lobbyGamePanel;
    private ChatMessagePanel m_chatPanel;

    public LobbyAdminConsole(LobbyServer server) {
        super("Lobby Admin Console");
        this.m_server = server;
        this.setDefaultCloseOperation(0);
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
    }

    private void createComponents() {
        this.m_backupNow = new JButton("Backup Now");
        this.m_bootPlayer = new JButton("Boot Player");
        this.m_debugPlayer = new JButton("Debug Player");
        this.m_exit = new JButton("Exit");
        this.m_executor = new DBExplorerPanel();
        this.m_allUsers = new AllUsersPanel(this.m_server.getMessenger());
        this.m_lobbyGamePanel = new LobbyGamePanel(this.m_server.getMessengers());
        Chat chat = new Chat("_LOBBY_CHAT", this.m_server.getMessengers());
        this.m_chatPanel = new ChatMessagePanel(chat);
    }

    private void layoutComponents() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.m_exit);
        toolBar.add(this.m_bootPlayer);
        toolBar.add(this.m_backupNow);
        toolBar.add(this.m_debugPlayer);
        this.add((Component)toolBar, "North");
        JSplitPane leftTopSplit = new JSplitPane(0);
        leftTopSplit.setTopComponent(this.m_executor);
        leftTopSplit.setBottomComponent(this.m_lobbyGamePanel);
        JSplitPane letSplit = new JSplitPane(0);
        letSplit.setTopComponent(leftTopSplit);
        letSplit.setBottomComponent(this.m_chatPanel);
        JSplitPane mainSplit = new JSplitPane(1);
        mainSplit.setLeftComponent(letSplit);
        mainSplit.setRightComponent(this.m_allUsers);
        this.add((Component)mainSplit, "Center");
    }

    private void setupListeners() {
        this.m_bootPlayer.addActionListener(new BootPlayerAction(this, this.m_server.getMessenger()));
        this.m_debugPlayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LobbyAdminConsole.this.debugPlayer();
            }
        });
        this.m_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int option = JOptionPane.showConfirmDialog(LobbyAdminConsole.this, "Are you Sure?", "Are you Sure", 0);
                if (option != 0) {
                    return;
                }
                System.exit(0);
            }
        });
        this.m_backupNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Database.backup();
            }
        });
    }

    private void setWidgetActivation() {
    }

    private void debugPlayer() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        JComboBox combo = new JComboBox(model);
        model.addElement("");
        for (INode node : new TreeSet<INode>(this.m_server.getMessenger().getNodes())) {
            if (node.equals(this.m_server.getMessenger().getLocalNode())) continue;
            model.addElement(node.getName());
        }
        if (model.getSize() == 1) {
            JOptionPane.showMessageDialog(this, "No remote players", "No Remote Players", 0);
            return;
        }
        int rVal = JOptionPane.showConfirmDialog(this, combo, "Select player to debug", 2);
        if (rVal != 0) {
            return;
        }
        String name = (String)combo.getSelectedItem();
        for (final INode node : this.m_server.getMessenger().getNodes()) {
            if (!node.getName().equals(name)) continue;
            Runnable r = new Runnable(){

                public void run() {
                    s_logger.info("Getting debug info for:" + node);
                    RemoteName remoteName = HeartBeat.getHeartBeatName(node);
                    IHeartBeat heartBeat = (IHeartBeat)LobbyAdminConsole.this.m_server.getMessengers().getRemoteMessenger().getRemote(remoteName);
                    s_logger.info("Debug info for:" + node);
                    s_logger.info(heartBeat.getDebugInfo());
                }
            };
            Thread t = new Thread(r, "Debug player called at " + new Date());
            t.setDaemon(true);
            t.start();
            return;
        }
        s_logger.info("No node found named:" + name);
    }
}

