/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import games.strategy.util.Tuple;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BannedIpController {
    private static final Logger s_logger = Logger.getLogger(BannedIpController.class.getName());

    public void addBannedIp(String ip) {
        this.addBannedIp(ip, null);
    }

    public void addBannedIp(String ip, Date banTill) {
        if (this.isIpBanned(ip).getFirst().booleanValue()) {
            this.removeBannedIp(ip);
        }
        Timestamp banTillTs = null;
        if (banTill != null) {
            banTillTs = new Timestamp(banTill.getTime());
        }
        s_logger.fine("Banning ip:" + ip);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into banned_ips (ip, ban_till) values (?, ?)");
            ps.setString(1, ip);
            ps.setTimestamp(2, banTillTs);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate banned ip:" + ip + " error:" + sqle.getMessage());
                return;
            }
            s_logger.log(Level.SEVERE, "Error inserting banned ip:" + ip, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void removeBannedIp(String ip) {
        s_logger.fine("Removing banned ip:" + ip);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("delete from banned_ips where ip = ?");
            ps.setString(1, ip);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error deleting banned ip:" + ip, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public Tuple<Boolean, Timestamp> isIpBanned(String ip) {
        boolean found = false;
        boolean expired = false;
        Timestamp banTill = null;
        String sql = "select ip, ban_till from banned_ips where ip = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select ip, ban_till from banned_ips where ip = ?");
            ps.setString(1, ip);
            ResultSet rs = ps.executeQuery();
            found = rs.next();
            if (found && (banTill = rs.getTimestamp(2)) != null && banTill.getTime() < System.currentTimeMillis()) {
                s_logger.fine("Ban expired for:" + ip);
                expired = true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing banned ip existence:" + ip + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        if (expired) {
            this.removeBannedIp(ip);
            return new Tuple<Boolean, Timestamp>(false, banTill);
        }
        return new Tuple<Boolean, Timestamp>(found, banTill);
    }
}

