/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.lobby.server.userDB;

import games.strategy.engine.lobby.server.userDB.Database;
import games.strategy.engine.lobby.server.userDB.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutedIpController {
    private static final Logger s_logger = Logger.getLogger(MutedIpController.class.getName());

    public void addMutedIp(String ip) {
        this.addMutedIp(ip, null);
    }

    public void addMutedIp(String ip, Date muteTill) {
        if (this.isIpMuted(ip)) {
            this.removeMutedIp(ip);
        }
        Timestamp muteTillTs = null;
        if (muteTill != null) {
            muteTillTs = new Timestamp(muteTill.getTime());
        }
        s_logger.fine("Muting ip:" + ip);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("insert into muted_ips (ip, mute_till) values (?, ?)");
            ps.setString(1, ip);
            ps.setTimestamp(2, muteTillTs);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 30000) {
                s_logger.info("Tried to create duplicate muted ip:" + ip + " error:" + sqle.getMessage());
                return;
            }
            s_logger.log(Level.SEVERE, "Error inserting muted ip:" + ip, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public void removeMutedIp(String ip) {
        s_logger.fine("Removing muted ip:" + ip);
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("delete from muted_ips where ip = ?");
            ps.setString(1, ip);
            ps.execute();
            ps.close();
            con.commit();
        }
        catch (SQLException sqle) {
            s_logger.log(Level.SEVERE, "Error deleting muted ip:" + ip, sqle);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
    }

    public boolean isIpMuted(String ip) {
        long muteTill = this.getIpUnmuteTime(ip);
        return muteTill > System.currentTimeMillis();
    }

    public long getIpUnmuteTime(String ip) {
        long result = -1L;
        boolean expired = false;
        String sql = "select ip, mute_till from muted_ips where ip = ?";
        Connection con = Database.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("select ip, mute_till from muted_ips where ip = ?");
            ps.setString(1, ip);
            ResultSet rs = ps.executeQuery();
            boolean found = rs.next();
            if (found) {
                Timestamp muteTill = rs.getTimestamp(2);
                result = muteTill.getTime();
                if (result < System.currentTimeMillis()) {
                    s_logger.fine("Mute expired for:" + ip);
                    expired = true;
                }
            } else {
                result = -1L;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException sqle) {
            s_logger.info("Error for testing muted ip existence:" + ip + " error:" + sqle.getMessage());
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        if (expired) {
            this.removeMutedIp(ip);
            result = -1L;
        }
        return result;
    }

    public List<String> getIPsThatAreStillMuted(List<String> ips) {
        ArrayList<String> results = new ArrayList<String>();
        String sql = "select ip, mute_till from muted_ips where ip = ?";
        Connection con = Database.getConnection();
        try {
            for (String ip : ips) {
                Timestamp muteTill;
                boolean found = false;
                boolean expired = false;
                PreparedStatement ps = con.prepareStatement("select ip, mute_till from muted_ips where ip = ?");
                ps.setString(1, ip);
                ResultSet rs = ps.executeQuery();
                found = rs.next();
                if (found && (muteTill = rs.getTimestamp(2)) != null && muteTill.getTime() < System.currentTimeMillis()) {
                    s_logger.fine("Mute expired for: " + ip);
                    expired = true;
                }
                rs.close();
                ps.close();
                if (!found || expired) continue;
                results.add(ip);
            }
        }
        catch (SQLException sqle) {
            s_logger.info("Error testing whether ips were muted: " + ips);
            throw new IllegalStateException(sqle.getMessage());
        }
        finally {
            DbUtil.closeConnection(con);
        }
        return results;
    }
}

