/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.MessengerException;
import games.strategy.engine.message.RemoteMethodCall;
import games.strategy.engine.message.RemoteMethodCallResults;
import games.strategy.engine.message.UnifiedMessenger;
import games.strategy.triplea.util.WrappedInvocationHandler;
import java.io.Serializable;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnifiedInvocationHandler
extends WrappedInvocationHandler {
    private final UnifiedMessenger m_messenger;
    private final String m_endPointName;
    private final boolean m_ignoreResults;
    private final Class<?> m_remoteType;

    public UnifiedInvocationHandler(UnifiedMessenger messenger, String endPointName, boolean ignoreResults, Class<?> remoteType) {
        super(endPointName);
        this.m_messenger = messenger;
        this.m_endPointName = endPointName;
        this.m_ignoreResults = ignoreResults;
        this.m_remoteType = remoteType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (super.shouldHandle(method, args)) {
            return super.handle(method, args);
        }
        if (args != null) {
            for (Object o : args) {
                if (o == null || o instanceof Serializable) continue;
                throw new IllegalArgumentException(o + " is not serializable, all remote method args must be serializable.  method:" + method);
            }
        }
        RemoteMethodCall remoteMethodMsg = new RemoteMethodCall(this.m_endPointName, method.getName(), args, method.getParameterTypes(), this.m_remoteType);
        if (this.m_ignoreResults) {
            this.m_messenger.invoke(this.m_endPointName, remoteMethodMsg);
            return null;
        }
        RemoteMethodCallResults response = this.m_messenger.invokeAndWait(this.m_endPointName, remoteMethodMsg);
        if (response.getException() != null) {
            if (response.getException() instanceof MessengerException) {
                MessengerException cle = (MessengerException)response.getException();
                cle.fillInInvokerStackTrace();
            }
            throw response.getException();
        }
        return response.getRVal();
    }
}

