/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.message;

import games.strategy.engine.message.ConnectionLostException;
import games.strategy.engine.message.HasEndPointImplementor;
import games.strategy.engine.message.HubInvocationResults;
import games.strategy.engine.message.HubInvoke;
import games.strategy.engine.message.InvocationInProgress;
import games.strategy.engine.message.NoLongerHasEndPointImplementor;
import games.strategy.engine.message.RemoteMethodCallResults;
import games.strategy.engine.message.RemoteNotFoundException;
import games.strategy.engine.message.SpokeInvocationResults;
import games.strategy.engine.message.SpokeInvoke;
import games.strategy.engine.message.UnifiedMessenger;
import games.strategy.net.GUID;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.IMessageListener;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedMessengerHub
implements IMessageListener,
IConnectionChangeListener {
    private static final Logger s_logger = Logger.getLogger(UnifiedMessengerHub.class.getName());
    private final UnifiedMessenger m_localUnified;
    private final IMessenger m_messenger;
    private final Map<String, Collection<INode>> m_endPoints = new HashMap<String, Collection<INode>>();
    private final Object m_endPointMutex = new Object();
    private final Map<GUID, InvocationInProgress> m_invocations = new ConcurrentHashMap<GUID, InvocationInProgress>();

    public UnifiedMessengerHub(IMessenger messenger, UnifiedMessenger localUnified) {
        this.m_messenger = messenger;
        this.m_localUnified = localUnified;
        this.m_messenger.addMessageListener(this);
        ((IServerMessenger)this.m_messenger).addConnectionChangeListener(this);
    }

    private void send(Serializable msg, INode to) {
        if (this.m_messenger.getLocalNode().equals(to)) {
            this.m_localUnified.messageReceived(msg, this.m_messenger.getLocalNode());
        } else {
            this.m_messenger.send(msg, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Serializable msg, INode from) {
        if (msg instanceof HasEndPointImplementor) {
            Object object = this.m_endPointMutex;
            synchronized (object) {
                HasEndPointImplementor hasEndPoint = (HasEndPointImplementor)msg;
                Collection<INode> nodes = this.m_endPoints.get(hasEndPoint.endPointName);
                if (nodes == null) {
                    nodes = new ArrayList<INode>();
                    this.m_endPoints.put(hasEndPoint.endPointName, nodes);
                }
                if (nodes.contains(from)) {
                    throw new IllegalStateException("Already contained, new" + from + " existing, " + nodes + " name " + hasEndPoint.endPointName);
                }
                nodes.add(from);
            }
        }
        if (msg instanceof NoLongerHasEndPointImplementor) {
            Object object = this.m_endPointMutex;
            synchronized (object) {
                NoLongerHasEndPointImplementor hasEndPoint = (NoLongerHasEndPointImplementor)msg;
                Collection<INode> nodes = this.m_endPoints.get(hasEndPoint.endPointName);
                if (nodes != null) {
                    if (!nodes.remove(from)) {
                        throw new IllegalStateException("Not removed!");
                    }
                    if (nodes.isEmpty()) {
                        this.m_endPoints.remove(hasEndPoint.endPointName);
                    }
                }
            }
        }
        if (msg instanceof HubInvoke) {
            HubInvoke invoke = (HubInvoke)msg;
            ArrayList<INode> endPointCols = new ArrayList<INode>();
            Object nodes = this.m_endPointMutex;
            synchronized (nodes) {
                if (this.m_endPoints.containsKey(invoke.call.getRemoteName())) {
                    endPointCols.addAll(this.m_endPoints.get(invoke.call.getRemoteName()));
                }
            }
            endPointCols.remove(from);
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.log(Level.FINEST, "Forwarding invocation:" + msg + " to:" + endPointCols);
            }
            if (endPointCols.isEmpty()) {
                if (invoke.needReturnValues) {
                    RemoteMethodCallResults results = new RemoteMethodCallResults(new RemoteNotFoundException("Not found:" + invoke.call.getRemoteName()));
                    this.send(new SpokeInvocationResults(results, invoke.methodCallID), from);
                }
            } else {
                this.invoke(invoke, endPointCols, from);
            }
        } else if (msg instanceof HubInvocationResults) {
            HubInvocationResults results = (HubInvocationResults)msg;
            this.results(results, from);
        }
    }

    private void results(HubInvocationResults results, INode from) {
        GUID methodID = results.methodCallID;
        InvocationInProgress invocationInProgress = this.m_invocations.get(methodID);
        boolean done = invocationInProgress.process(results, from);
        if (done) {
            this.m_invocations.remove(methodID);
            HubInvoke hubInvoke = invocationInProgress.getMethodCall();
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.log(Level.FINER, "Method returned:" + hubInvoke.call.getMethodName() + " for remote name:" + hubInvoke.call.getRemoteName() + " with id:" + hubInvoke.methodCallID);
            }
            if (invocationInProgress.shouldSendResults()) {
                this.sendResultsToCaller(methodID, invocationInProgress);
            }
        }
    }

    private void sendResultsToCaller(GUID methodID, InvocationInProgress invocationInProgress) {
        RemoteMethodCallResults result = invocationInProgress.getResults();
        INode caller = invocationInProgress.getCaller();
        SpokeInvocationResults spokeResults = new SpokeInvocationResults(result, methodID);
        this.send(spokeResults, caller);
    }

    private void invoke(HubInvoke hubInvoke, Collection<INode> remote, INode from) {
        if (hubInvoke.needReturnValues) {
            if (remote.size() != 1) {
                throw new IllegalStateException("Too many nodes:" + remote + " for remote name " + hubInvoke.call);
            }
            InvocationInProgress invocationInProgress = new InvocationInProgress(remote.iterator().next(), hubInvoke, from);
            this.m_invocations.put(hubInvoke.methodCallID, invocationInProgress);
            if (s_logger.isLoggable(Level.FINER)) {
                s_logger.log(Level.FINER, "Waiting for method:" + hubInvoke.call.getMethodName() + " for remote name:" + hubInvoke.call.getRemoteName() + " with id:" + hubInvoke.methodCallID);
            }
        }
        SpokeInvoke invoke = new SpokeInvoke(hubInvoke.methodCallID, hubInvoke.needReturnValues, hubInvoke.call, from);
        for (INode node : remote) {
            this.send(invoke, node);
        }
    }

    public void waitForNodesToImplement(String endPointName, long timeoutMS) {
        if (timeoutMS <= 0L) {
            timeoutMS = Integer.MAX_VALUE;
        }
        long endTime = timeoutMS + System.currentTimeMillis();
        while (System.currentTimeMillis() < endTime && !this.hasImplementors(endPointName)) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasImplementors(String endPointName) {
        Object object = this.m_endPointMutex;
        synchronized (object) {
            return this.m_endPoints.containsKey(endPointName) && !this.m_endPoints.get(endPointName).isEmpty();
        }
    }

    @Override
    public void connectionAdded(INode to) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionRemoved(INode to) {
        Object object = this.m_endPointMutex;
        synchronized (object) {
            for (Collection<INode> nodes : this.m_endPoints.values()) {
                nodes.remove(to);
            }
        }
        for (InvocationInProgress invocation : this.m_invocations.values()) {
            if (!invocation.isWaitingOn(to)) continue;
            RemoteMethodCallResults results = new RemoteMethodCallResults(new ConnectionLostException("Connection to " + to.getName() + " lost"));
            HubInvocationResults hubResults = new HubInvocationResults(results, invocation.getMethodCallID());
            this.results(hubResults, to);
        }
    }
}

