/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.random.IRandomSource;
import games.strategy.engine.random.MersenneTwister;
import games.strategy.util.IntegerMap;

public class PlainRandomSource
implements IRandomSource {
    private static MersenneTwister s_random;

    public static long getSeed() {
        Object seedObj = new Object();
        long seed = seedObj.hashCode();
        seed += System.currentTimeMillis();
        return seed += System.nanoTime();
    }

    public synchronized int[] getRandom(int max, int count, String annotation) {
        if (count <= 0) {
            throw new IllegalStateException("count must be > o, annotation:" + annotation);
        }
        int[] numbers = new int[count];
        for (int i = 0; i < count; ++i) {
            numbers[i] = this.getRandom(max, annotation);
        }
        return numbers;
    }

    public synchronized int getRandom(int max, String annotation) {
        if (s_random == null) {
            s_random = new MersenneTwister(PlainRandomSource.getSeed());
        }
        return s_random.nextInt(max);
    }

    public static void main(String[] args) {
        IntegerMap<Integer> results = new IntegerMap<Integer>();
        int[] random = new PlainRandomSource().getRandom(6, 100000, "Test");
        for (int i = 0; i < random.length; ++i) {
            results.add(Integer.valueOf(random[i] + 1), 1);
        }
        System.out.println(results);
    }
}

