/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.random;

import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.startup.ui.editors.DiceServerEditor;
import games.strategy.engine.framework.startup.ui.editors.EditorPanel;
import games.strategy.engine.framework.startup.ui.editors.IBean;
import games.strategy.engine.random.IRemoteDiceServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDiceRoller
implements IRemoteDiceServer {
    private static final long serialVersionUID = 6481409417543119539L;
    private final Properties m_props;
    private String m_toAddress;
    private String m_ccAddress;
    private String m_gameId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<PropertiesDiceRoller> loadFromFile() {
        File[] files;
        ArrayList<PropertiesDiceRoller> rollers = new ArrayList<PropertiesDiceRoller>();
        File f = new File(GameRunner.getRootFolder(), "dice_servers");
        if (!f.exists()) {
            throw new IllegalStateException("No dice server folder:" + f);
        }
        ArrayList<Properties> propFiles = new ArrayList<Properties>();
        for (File file : files = f.listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".properties")) continue;
            try {
                Properties props = new Properties();
                FileInputStream fin = new FileInputStream(file);
                try {
                    props.load(fin);
                    propFiles.add(props);
                }
                finally {
                    fin.close();
                }
            }
            catch (IOException e) {
                System.out.println("error reading file:" + file);
                e.printStackTrace();
            }
        }
        Collections.sort(propFiles, new Comparator<Properties>(){

            @Override
            public int compare(Properties o1, Properties o2) {
                int n1 = Integer.parseInt(o1.getProperty("order"));
                int n2 = Integer.parseInt(o2.getProperty("order"));
                return n1 - n2;
            }
        });
        for (Properties prop : propFiles) {
            rollers.add(new PropertiesDiceRoller(prop));
        }
        return rollers;
    }

    public PropertiesDiceRoller(Properties props) {
        this.m_props = props;
    }

    @Override
    public String getDisplayName() {
        return this.m_props.getProperty("name");
    }

    @Override
    public EditorPanel getEditor() {
        return new DiceServerEditor(this);
    }

    @Override
    public boolean sameType(IBean other) {
        return other instanceof PropertiesDiceRoller && this.getDisplayName().equals(other.getDisplayName());
    }

    @Override
    public boolean sendsEmail() {
        String property = this.m_props.getProperty("send.email");
        if (property == null) {
            return true;
        }
        return Boolean.valueOf(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String postRequest(int max, int numDice, String subjectMessage, String gameID, String gameUUID) throws IOException {
        if (gameID.trim().length() == 0) {
            gameID = "TripleA";
        }
        String message = gameID + ":" + subjectMessage;
        int maxLength = Integer.valueOf(this.m_props.getProperty("message.maxlength"));
        if (message.length() > maxLength) {
            message = message.substring(0, maxLength - 1);
        }
        PostMethod post = new PostMethod(this.m_props.getProperty("path"));
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("numdice", "" + numDice), new NameValuePair("numsides", "" + max), new NameValuePair("modroll", "No"), new NameValuePair("numroll", "1"), new NameValuePair("subject", message), new NameValuePair("roller", this.getToAddress()), new NameValuePair("gm", this.getCcAddress()), new NameValuePair("send", "true")};
        post.setRequestHeader("User-Agent", "triplea/" + EngineVersion.VERSION);
        post.setRequestHeader("X-Triplea-Game-UUID", gameUUID);
        post.setRequestBody(data);
        HttpClient client = new HttpClient();
        try {
            String result;
            String host = this.m_props.getProperty("host");
            int port = 80;
            if (this.m_props.getProperty("port") != null) {
                port = Integer.parseInt(this.m_props.getProperty("port"));
            }
            HostConfiguration config = client.getHostConfiguration();
            config.setHost(host, port);
            GameRunner2.addProxy(config);
            client.executeMethod(post);
            String string = result = post.getResponseBodyAsString();
            return string;
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public String getInfoText() {
        return this.m_props.getProperty("infotext");
    }

    @Override
    public int[] getDice(String string, int count) throws IOException, InvocationTargetException {
        String rollEndString;
        String rollStartString;
        int endIndex;
        int startIndex;
        String errorStartString = this.m_props.getProperty("error.start");
        String errorEndString = this.m_props.getProperty("error.end");
        if (errorStartString != null && errorStartString.length() > 0 && errorEndString != null && errorEndString.length() > 0 && (startIndex = string.indexOf(errorStartString)) >= 0 && (endIndex = string.indexOf(errorEndString, startIndex + errorStartString.length())) > 0) {
            String error = string.substring(startIndex + errorStartString.length(), endIndex);
            throw new InvocationTargetException(null, error);
        }
        if (count == 1) {
            rollStartString = this.m_props.getProperty("roll.single.start");
            rollEndString = this.m_props.getProperty("roll.single.end");
        } else {
            rollStartString = this.m_props.getProperty("roll.multiple.start");
            rollEndString = this.m_props.getProperty("roll.multiple.end");
        }
        int startIndex2 = string.indexOf(rollStartString);
        if (startIndex2 == -1) {
            throw new IOException("Cound not find start index, text returned is:" + string);
        }
        int endIndex2 = string.indexOf(rollEndString, startIndex2 += rollStartString.length());
        if (endIndex2 == -1) {
            throw new IOException("Cound not find end index");
        }
        StringTokenizer tokenizer = new StringTokenizer(string.substring(startIndex2, endIndex2), " ,", false);
        int[] rVal = new int[count];
        for (int i = 0; i < count; ++i) {
            try {
                rVal[i] = Integer.parseInt(tokenizer.nextToken()) - 1;
                continue;
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        }
        return rVal;
    }

    @Override
    public String getToAddress() {
        return this.m_toAddress;
    }

    @Override
    public void setToAddress(String toAddress) {
        this.m_toAddress = toAddress;
    }

    @Override
    public String getCcAddress() {
        return this.m_ccAddress;
    }

    @Override
    public void setCcAddress(String ccAddress) {
        this.m_ccAddress = ccAddress;
    }

    @Override
    public boolean supportsGameId() {
        String gameid = this.m_props.getProperty("gameid");
        return "true".equals(gameid);
    }

    @Override
    public void setGameId(String gameId) {
        this.m_gameId = gameId;
    }

    @Override
    public String getGameId() {
        return this.m_gameId;
    }

    @Override
    public String getHelpText() {
        return this.getInfoText();
    }
}

