/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net;

import games.strategy.net.CouldNotLogInException;
import games.strategy.net.DefaultObjectStreamFactory;
import games.strategy.net.IConnectionLogin;
import games.strategy.net.IMessageListener;
import games.strategy.net.IMessenger;
import games.strategy.net.IMessengerErrorListener;
import games.strategy.net.INode;
import games.strategy.net.IObjectStreamFactory;
import games.strategy.net.MessageHeader;
import games.strategy.net.Node;
import games.strategy.net.nio.ClientQuarantineConversation;
import games.strategy.net.nio.NIOSocket;
import games.strategy.net.nio.NIOSocketListener;
import games.strategy.net.nio.QuarantineConversation;
import games.strategy.util.ListenerList;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;

public class ClientMessenger
implements IMessenger,
NIOSocketListener {
    private INode m_node;
    private final ListenerList<IMessageListener> m_listeners = new ListenerList();
    private final ListenerList<IMessengerErrorListener> m_errorListeners = new ListenerList();
    private final CountDownLatch m_initLatch = new CountDownLatch(1);
    private Exception m_connectionRefusedError;
    private final NIOSocket m_socket;
    private final SocketChannel m_socketChannel = SocketChannel.open();
    private INode m_serverNode;
    private volatile boolean m_shutDown = false;

    public ClientMessenger(String host, int port, String name, String mac, IConnectionLogin login) throws IOException, UnknownHostException, CouldNotLogInException {
        this(host, port, name, mac, new DefaultObjectStreamFactory(), login);
    }

    public ClientMessenger(String host, int port, String name, String mac) throws IOException, UnknownHostException, CouldNotLogInException {
        this(host, port, name, mac, new DefaultObjectStreamFactory());
    }

    public ClientMessenger(String host, int port, String name, String mac, IObjectStreamFactory streamFact) throws IOException, UnknownHostException, CouldNotLogInException {
        this(host, port, name, mac, streamFact, null);
    }

    public ClientMessenger(String host, int port, String name, String mac, IObjectStreamFactory streamFact, IConnectionLogin login) throws IOException, UnknownHostException, CouldNotLogInException {
        this.m_socketChannel.configureBlocking(false);
        InetSocketAddress remote = new InetSocketAddress(host, port);
        if (!this.m_socketChannel.connect(remote)) {
            int waitTimeMilliseconds = 0;
            while (true) {
                if (waitTimeMilliseconds > 10000) {
                    this.m_socketChannel.close();
                    throw new IOException("Connection refused");
                }
                if (this.m_socketChannel.finishConnect()) break;
                try {
                    Thread.sleep(50L);
                    waitTimeMilliseconds += 50;
                }
                catch (InterruptedException e) {}
            }
        }
        Socket socket = this.m_socketChannel.socket();
        socket.setKeepAlive(true);
        this.m_socket = new NIOSocket(streamFact, this, name);
        ClientQuarantineConversation conversation = new ClientQuarantineConversation(login, this.m_socketChannel, this.m_socket, name, mac);
        this.m_socket.add(this.m_socketChannel, conversation);
        conversation.showCredentials();
        try {
            this.m_initLatch.await();
        }
        catch (InterruptedException e) {
            this.m_connectionRefusedError = e;
            try {
                this.m_socketChannel.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        if (conversation.getErrorMessage() != null || this.m_connectionRefusedError != null) {
            this.m_socket.shutDown();
            if (conversation.getErrorMessage() != null) {
                login.notifyFailedLogin(conversation.getErrorMessage());
                throw new CouldNotLogInException();
            }
            if (this.m_connectionRefusedError instanceof CouldNotLogInException) {
                throw (CouldNotLogInException)this.m_connectionRefusedError;
            }
            if (this.m_connectionRefusedError != null) {
                throw new IOException(this.m_connectionRefusedError.getMessage());
            }
        }
    }

    public synchronized void send(Serializable msg, INode to) {
        MessageHeader header = new MessageHeader(to, this.m_node, msg);
        this.m_socket.send(this.m_socketChannel, header);
    }

    public synchronized void broadcast(Serializable msg) {
        MessageHeader header = new MessageHeader(this.m_node, msg);
        this.m_socket.send(this.m_socketChannel, header);
    }

    public void addMessageListener(IMessageListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeMessageListener(IMessageListener listener) {
        this.m_listeners.remove(listener);
    }

    public void addErrorListener(IMessengerErrorListener listener) {
        this.m_errorListeners.add(listener);
    }

    public void removeErrorListener(IMessengerErrorListener listener) {
        this.m_errorListeners.remove(listener);
    }

    public boolean isConnected() {
        return this.m_socketChannel.isConnected();
    }

    public void shutDown() {
        this.m_shutDown = true;
        this.m_socket.shutDown();
        try {
            this.m_socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void messageReceived(MessageHeader msg, SocketChannel channel) {
        if (msg.getFor() != null && !msg.getFor().equals(this.m_node)) {
            throw new IllegalStateException("msg not for me:" + msg);
        }
        for (IMessageListener listener : this.m_listeners) {
            listener.messageReceived(msg.getMessage(), msg.getFrom());
        }
    }

    public INode getLocalNode() {
        return this.m_node;
    }

    public INode getServerNode() {
        return this.m_serverNode;
    }

    public boolean isServer() {
        return false;
    }

    public void socketUnqaurantined(SocketChannel channel, QuarantineConversation converstaion2) {
        ClientQuarantineConversation conversation = (ClientQuarantineConversation)converstaion2;
        this.m_node = new Node(conversation.getLocalName(), conversation.getNetworkVisibleSocketAdress());
        this.m_serverNode = new Node(conversation.getServerName(), conversation.getServerLocalAddress());
        this.m_initLatch.countDown();
    }

    public void socketError(SocketChannel channel, Exception error) {
        if (this.m_shutDown) {
            return;
        }
        this.m_connectionRefusedError = error;
        for (IMessengerErrorListener errorListener : this.m_errorListeners) {
            errorListener.messengerInvalid(this, error);
        }
        this.shutDown();
        this.m_initLatch.countDown();
    }

    public INode getRemoteNode(SocketChannel channel) {
        return this.m_serverNode;
    }

    public InetSocketAddress getRemoteServerSocketAddress() {
        return (InetSocketAddress)this.m_socketChannel.socket().getRemoteSocketAddress();
    }
}

