/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import games.strategy.net.ILoginValidator;
import games.strategy.net.MessageHeader;
import games.strategy.net.Node;
import games.strategy.net.ServerMessenger;
import games.strategy.net.nio.NIOSocket;
import games.strategy.net.nio.QuarantineConversation;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.nio.ch.SocketAdaptor;

public class ServerQuarantineConversation
extends QuarantineConversation {
    private static final Logger s_logger = Logger.getLogger(ServerQuarantineConversation.class.getName());
    private final ILoginValidator m_validator;
    private final SocketChannel m_channel;
    private final NIOSocket m_socket;
    private STEP m_step = STEP.READ_NAME;
    private String m_remoteName;
    private String m_remoteMac;
    private Map<String, String> challenge;
    private final ServerMessenger m_serverMessenger;

    public ServerQuarantineConversation(ILoginValidator validator, SocketChannel channel, NIOSocket socket, ServerMessenger serverMessenger) {
        this.m_validator = validator;
        this.m_socket = socket;
        this.m_channel = channel;
        this.m_serverMessenger = serverMessenger;
    }

    public String getRemoteName() {
        return this.m_remoteName;
    }

    public String getRemoteMac() {
        return this.m_remoteMac;
    }

    public QuarantineConversation.ACTION message(Object o) {
        try {
            switch (this.m_step) {
                case READ_NAME: {
                    this.m_remoteName = (String)o;
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "read name:" + this.m_remoteName);
                    }
                    this.m_step = STEP.READ_MAC;
                    return QuarantineConversation.ACTION.NONE;
                }
                case READ_MAC: {
                    this.m_remoteMac = (String)o;
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "read mac:" + this.m_remoteMac);
                    }
                    if (this.m_validator != null) {
                        this.challenge = this.m_validator.getChallengeProperties(this.m_remoteName, this.m_channel.socket().getRemoteSocketAddress());
                    }
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "writing challenge:" + this.challenge);
                    }
                    this.send((Serializable)((Object)this.challenge));
                    this.m_step = STEP.CHALLENGE;
                    return QuarantineConversation.ACTION.NONE;
                }
                case CHALLENGE: {
                    Map response = (Map)o;
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "read challenge response:" + response);
                    }
                    if (this.m_validator != null) {
                        String error = this.m_validator.verifyConnection(this.challenge, response, this.m_remoteName, this.m_remoteMac, this.m_channel.socket().getRemoteSocketAddress());
                        if (s_logger.isLoggable(Level.FINER)) {
                            s_logger.log(Level.FINER, "error:" + error);
                        }
                        this.send((Serializable)((Object)error));
                        if (error != null) {
                            this.m_step = STEP.ACK_ERROR;
                            return QuarantineConversation.ACTION.NONE;
                        }
                    } else {
                        this.send(null);
                    }
                    this.m_remoteName = this.m_serverMessenger.getUniqueName(this.m_remoteName);
                    if (s_logger.isLoggable(Level.FINER)) {
                        s_logger.log(Level.FINER, "Sending name:" + this.m_remoteName);
                    }
                    this.send((Serializable)new String[]{this.m_remoteName, this.m_serverMessenger.getLocalNode().getName()});
                    this.send((Serializable)new InetSocketAddress[]{(InetSocketAddress)this.m_channel.socket().getRemoteSocketAddress(), this.m_serverMessenger.getLocalNode().getSocketAddress()});
                    this.m_serverMessenger.NotifyPlayerLogin(this.m_remoteName, ((SocketAdaptor)this.m_channel.socket()).getInetAddress().getHostAddress(), this.m_remoteMac);
                    return QuarantineConversation.ACTION.UNQUARANTINE;
                }
                case ACK_ERROR: {
                    return QuarantineConversation.ACTION.TERMINATE;
                }
            }
            throw new IllegalStateException("Invalid state");
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "Error with connection", t);
            return QuarantineConversation.ACTION.TERMINATE;
        }
    }

    private void send(Serializable object) {
        MessageHeader header = new MessageHeader(Node.NULL_NODE, Node.NULL_NODE, object);
        this.m_socket.send(this.m_channel, header);
    }

    public void close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STEP {
        READ_NAME,
        READ_MAC,
        CHALLENGE,
        ACK_ERROR;

    }
}

