/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.net.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class SocketReadData {
    public static final int MAX_MESSAGE_SIZE = 10000000;
    private static final Logger s_logger = Logger.getLogger(SocketReadData.class.getName());
    private static final AtomicInteger s_counter = new AtomicInteger();
    public static final int MAGIC = -1694498816;
    private int m_targetSize = -1;
    private ByteBuffer m_sizeBuffer;
    private ByteBuffer m_contentBuffer;
    private final SocketChannel m_channel;
    private final int m_number = s_counter.incrementAndGet();
    private int m_readCalls;

    public SocketReadData(SocketChannel channel) {
        this.m_channel = channel;
    }

    public boolean read(SocketChannel channel) throws IOException {
        int size;
        ++this.m_readCalls;
        if (this.m_targetSize < 0) {
            if (this.m_sizeBuffer == null) {
                this.m_sizeBuffer = ByteBuffer.allocate(4);
            }
            size = channel.read(this.m_sizeBuffer);
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.finest("read size_buffer bytes:" + size);
            }
            if (size == -1) {
                throw new IOException("Socket closed");
            }
            if (!this.m_sizeBuffer.hasRemaining()) {
                this.m_sizeBuffer.flip();
                this.m_targetSize = this.m_sizeBuffer.getInt();
                if ((this.m_targetSize & 0xFF000000) != -1694498816) {
                    throw new IOException("Did not write magic!");
                }
                this.m_targetSize &= 0xFFFFFF;
                if (this.m_targetSize <= 0 || this.m_targetSize > 10000000) {
                    throw new IOException("Invalid triplea packet size:" + this.m_targetSize);
                }
                this.m_contentBuffer = ByteBuffer.allocate(this.m_targetSize);
                this.m_sizeBuffer = null;
            } else {
                return false;
            }
        }
        size = channel.read(this.m_contentBuffer);
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.finest("read content bytes:" + size);
        }
        if (size == -1) {
            throw new IOException("Socket closed");
        }
        return !this.m_contentBuffer.hasRemaining();
    }

    public SocketChannel getChannel() {
        return this.m_channel;
    }

    public byte[] getData() {
        byte[] rVal = new byte[this.m_contentBuffer.capacity()];
        this.m_contentBuffer.flip();
        this.m_contentBuffer.get(rVal);
        this.m_contentBuffer = null;
        return rVal;
    }

    public int size() {
        return this.m_targetSize + 4;
    }

    public int getReadCalls() {
        return this.m_readCalls;
    }

    public String toString() {
        return "<id:" + this.m_number + " size:" + this.m_targetSize + ">";
    }
}

