/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.sound;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.framework.GameRunner;
import games.strategy.sound.ClipCache;
import games.strategy.sound.SoundPath;
import games.strategy.sound.SoundProperties;
import games.strategy.triplea.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipPlayer {
    private static ClipPlayer s_clipPlayer;
    private boolean m_beSilent = false;
    private final HashSet<String> m_mutedClips = new HashSet();
    private final HashMap<String, List<File>> m_sounds = new HashMap();
    private final ResourceLoader m_resourceLoader;
    private final Set<String> m_subFolders = new HashSet<String>();
    private final ClipCache m_clipCache = new ClipCache(24);
    private static final String ASSETS_SOUNDS_FOLDER = "sounds";
    private static final String SOUND_PREFERENCE_GLOBAL_SWITCH = "beSilent2";
    private static final String SOUND_PREFERENCE_PREFIX = "sound_";

    public static synchronized ClipPlayer getInstance() {
        if (s_clipPlayer == null) {
            s_clipPlayer = new ClipPlayer(ResourceLoader.getMapResourceLoader(null));
            SoundPath.preLoadSounds(SoundPath.SoundType.GENERAL);
        }
        return s_clipPlayer;
    }

    public static synchronized ClipPlayer getInstance(ResourceLoader resourceLoader, GameData data) {
        if (s_clipPlayer == null || ClipPlayer.s_clipPlayer.m_resourceLoader != resourceLoader) {
            if (s_clipPlayer != null) {
                ClipPlayer.s_clipPlayer.m_clipCache.removeAll();
            }
            s_clipPlayer = new ClipPlayer(resourceLoader, data);
            SoundPath.preLoadSounds(SoundPath.SoundType.GENERAL);
        }
        return s_clipPlayer;
    }

    private ClipPlayer(ResourceLoader resourceLoader) {
        this.m_resourceLoader = resourceLoader;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        this.m_beSilent = prefs.getBoolean(SOUND_PREFERENCE_GLOBAL_SWITCH, false);
        HashSet<String> choices = SoundPath.getAllSoundOptions();
        for (String sound : choices) {
            boolean muted = prefs.getBoolean(SOUND_PREFERENCE_PREFIX + sound, false);
            if (!muted) continue;
            this.m_mutedClips.add(sound);
        }
    }

    private ClipPlayer(ResourceLoader resourceLoader, GameData data) {
        this(resourceLoader);
        for (PlayerID p : data.getPlayerList().getPlayers()) {
            this.m_subFolders.add(p.getName());
        }
    }

    public static void setBeSilent(boolean aBool) {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        clipPlayer.m_beSilent = aBool;
        Preferences prefs = Preferences.userNodeForPackage(clipPlayer.getClass());
        prefs.putBoolean(SOUND_PREFERENCE_GLOBAL_SWITCH, clipPlayer.m_beSilent);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean getBeSilent() {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        return clipPlayer.m_beSilent;
    }

    private void putSoundInPreferences(String clip, boolean isMuted) {
        ClipPlayer clipPlayer = ClipPlayer.getInstance();
        Preferences prefs = Preferences.userNodeForPackage(clipPlayer.getClass());
        prefs.putBoolean(SOUND_PREFERENCE_PREFIX + clip, isMuted);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<IEditableProperty> getSoundOptions(SoundPath.SoundType sounds) {
        return SoundPath.getSoundOptions(sounds);
    }

    public boolean isMuted(String clipName) {
        return this.m_mutedClips.contains(clipName);
    }

    public void setMute(String clipName, boolean value) {
        boolean isCurrentCorrect;
        boolean bl = isCurrentCorrect = this.m_mutedClips.contains(clipName) == value;
        if (isCurrentCorrect) {
            return;
        }
        if (value) {
            this.m_mutedClips.add(clipName);
        } else {
            this.m_mutedClips.remove(clipName);
        }
        this.putSoundInPreferences(clipName, value);
    }

    public static void play(String clipName, String subFolder) {
        ClipPlayer.getInstance().playClip(clipName, subFolder);
    }

    private void playClip(final String clipName, final String subFolder) {
        Runnable loadSounds = new Runnable(){

            public void run() {
                Clip clip = ClipPlayer.this.loadClip(clipName, subFolder, false);
                if (clip != null) {
                    clip.setFramePosition(0);
                    clip.loop(0);
                }
            }
        };
        new Thread(loadSounds, "Triplea sound loader for " + clipName).start();
    }

    public void preLoadClip(String clipName) {
        this.loadClip(clipName, null, true);
        for (String sub : this.m_subFolders) {
            this.loadClip(clipName, sub, true);
        }
    }

    private Clip loadClip(String clipName, String subFolder, boolean parseThenTestOnly) {
        if (this.m_beSilent || this.isMuted(clipName)) {
            return null;
        }
        Clip clip = this.loadClipPath(clipName + (subFolder == null ? "" : "_" + subFolder), subFolder != null, parseThenTestOnly);
        if (clip == null) {
            return this.loadClipPath(clipName, false, parseThenTestOnly);
        }
        return clip;
    }

    private Clip loadClipPath(String pathName, boolean subFolder, boolean parseThenTestOnly) {
        if (!this.m_sounds.containsKey(pathName)) {
            this.parseClipPaths(pathName, subFolder);
        }
        List<File> availableSounds = this.m_sounds.get(pathName);
        if (parseThenTestOnly || availableSounds == null || availableSounds.isEmpty()) {
            return null;
        }
        Collections.shuffle(availableSounds);
        File clipFile = availableSounds.get(0);
        return this.m_clipCache.get(clipFile);
    }

    private void parseClipPaths(String pathName, boolean subFolder) {
        String resourcePath = SoundProperties.getInstance(this.m_resourceLoader).getProperty(pathName);
        if (resourcePath == null) {
            resourcePath = SoundProperties.getInstance(this.m_resourceLoader).getDefaultEraFolder() + File.separator + pathName;
        }
        resourcePath = resourcePath.replace('/', File.separatorChar);
        resourcePath = resourcePath.replace('\\', File.separatorChar);
        ArrayList<File> availableSounds = new ArrayList<File>();
        for (String path : resourcePath.split(";")) {
            availableSounds.addAll(this.createAndAddClips(ASSETS_SOUNDS_FOLDER + File.separator + path));
        }
        if (availableSounds.isEmpty()) {
            String genericPath = "generic" + File.separator + pathName;
            availableSounds.addAll(this.createAndAddClips(ASSETS_SOUNDS_FOLDER + File.separator + genericPath));
        }
        this.m_sounds.put(pathName, availableSounds);
    }

    private List<File> createAndAddClips(String resourceAndPath) {
        File thisSound;
        ArrayList<File> availableSounds = new ArrayList<File>();
        URL thisSoundURL = this.m_resourceLoader.getResource(resourceAndPath);
        if (thisSoundURL == null) {
            return availableSounds;
        }
        try {
            URI thisSoundURI = thisSoundURL.toURI();
            thisSound = new File(thisSoundURI);
        }
        catch (URISyntaxException e) {
            thisSound = new File(thisSoundURL.getPath());
        }
        if (thisSound == null || !thisSound.exists()) {
            return availableSounds;
        }
        if (!thisSound.isDirectory()) {
            if (!(thisSound.getName().endsWith(".wav") || thisSound.getName().endsWith(".au") || thisSound.getName().endsWith(".aiff") || thisSound.getName().endsWith(".midi"))) {
                return availableSounds;
            }
            if (ClipPlayer.testClipSuccessful(thisSound)) {
                availableSounds.add(thisSound);
            }
        } else {
            for (File sound : thisSound.listFiles()) {
                if (!sound.getName().endsWith(".wav") && !sound.getName().endsWith(".au") && !sound.getName().endsWith(".aiff") && !sound.getName().endsWith(".midi") || !ClipPlayer.testClipSuccessful(sound)) continue;
                availableSounds.add(sound);
            }
        }
        return availableSounds;
    }

    static synchronized Clip createClip(File clipFile, boolean testOnly) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(clipFile);
            AudioFormat format = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            if (!testOnly) {
                return clip;
            }
            clip.close();
            return null;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace(System.out);
        }
        catch (RuntimeException re) {
            re.printStackTrace(System.out);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean testClipSuccessful(File clipFile) {
        block11: {
            Line clip = null;
            boolean successful = false;
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(clipFile);
                AudioFormat format = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                clip = (Clip)AudioSystem.getLine(info);
                clip.open(audioInputStream);
                successful = true;
            }
            catch (LineUnavailableException e) {
                e.printStackTrace(System.out);
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace(System.out);
            }
            catch (RuntimeException re) {
                re.printStackTrace(System.out);
            }
            finally {
                if (clip == null) break block11;
                clip.close();
                if (!successful) break block11;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        ClipPlayer.getInstance();
        File root = new File(GameRunner.getRootFolder(), "assets" + File.separator + ASSETS_SOUNDS_FOLDER);
        for (File folder : root.listFiles()) {
            if (!folder.getName().equals("ww2") && !folder.getName().equals("preindustrial") && !folder.getName().equals("classical")) continue;
            for (File file : folder.listFiles()) {
                if (file.getName().indexOf("svn") != -1) continue;
                String name = folder.getName() + File.separator + file.getName();
                ArrayList<File> availableSounds = new ArrayList<File>();
                availableSounds.addAll(ClipPlayer.getInstance().createAndAddClips(ASSETS_SOUNDS_FOLDER + File.separator + name));
                ClipPlayer.getInstance().m_sounds.put(name, availableSounds);
            }
        }
        block4: while (true) {
            File[] arr$ = root.listFiles();
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                File folder;
                if (i$ >= len$) continue block4;
                folder = arr$[i$];
                if (folder.getName().equals("ww2") || folder.getName().equals("preindustrial") || folder.getName().equals("classical")) {
                    for (File file : folder.listFiles()) {
                        if (file.getName().indexOf("svn") != -1) continue;
                        ClipPlayer.play(folder.getName() + File.separator + file.getName(), null);
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i$;
            }
            break;
        }
    }
}

