/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea;

import games.strategy.common.player.AbstractHumanPlayer;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.net.GUID;
import games.strategy.sound.ClipPlayer;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.BidPurchaseDelegate;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.SpecialMoveDelegate;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.delegate.dataObjects.BattleListing;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.dataObjects.FightBattleDetails;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.delegate.dataObjects.TechResults;
import games.strategy.triplea.delegate.dataObjects.TechRoll;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IBattleDelegate;
import games.strategy.triplea.delegate.remote.IEditDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.BattleDisplay;
import games.strategy.triplea.ui.PlaceData;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TripleAPlayer
extends AbstractHumanPlayer<TripleAFrame>
implements IGamePlayer,
ITripleaPlayer {
    private boolean m_soundPlayedAlreadyCombatMove = false;
    private boolean m_soundPlayedAlreadyNonCombatMove = false;
    private boolean m_soundPlayedAlreadyPurchase = false;
    private boolean m_soundPlayedAlreadyTechnology = false;
    private boolean m_soundPlayedAlreadyBattle = false;
    private boolean m_soundPlayedAlreadyEndTurn = false;
    private boolean m_soundPlayedAlreadyPlacement = false;
    private final AbstractAction m_editModeAction = new AbstractAction(){
        private static final long serialVersionUID = -8076017427171022731L;

        public void actionPerformed(ActionEvent ae) {
            boolean editMode = ((ButtonModel)ae.getSource()).isSelected();
            try {
                IEditDelegate editDelegate = (IEditDelegate)TripleAPlayer.this.getPlayerBridge().getRemote("edit");
                editDelegate.setEditMode(editMode);
            }
            catch (Exception e) {
                e.printStackTrace();
                ((TripleAFrame)TripleAPlayer.this.m_ui).getEditModeButtonModel().setSelected(!((TripleAFrame)TripleAPlayer.this.m_ui).getEditModeButtonModel().isSelected());
            }
        }
    };

    public TripleAPlayer(String name, String type) {
        super(name, type);
    }

    @Override
    public void reportError(String error) {
        ((TripleAFrame)this.m_ui).notifyError(error);
    }

    @Override
    public void reportMessage(String message, String title) {
        ((TripleAFrame)this.m_ui).notifyMessage(message, title);
    }

    @Override
    public void reportPoliticalMessage(String message) {
        ((TripleAFrame)this.m_ui).notifyPoliticalMessage(message);
    }

    @Override
    public void start(String name) {
        boolean badStep = false;
        try {
            ((TripleAFrame)this.m_ui).setEditDelegate((IEditDelegate)this.getPlayerBridge().getRemote("edit"));
        }
        catch (Exception e) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((TripleAFrame)TripleAPlayer.this.m_ui).getEditModeButtonModel().addActionListener(TripleAPlayer.this.m_editModeAction);
                ((TripleAFrame)TripleAPlayer.this.m_ui).getEditModeButtonModel().setEnabled(true);
            }
        });
        if (name.endsWith("Bid")) {
            this.purchase(true);
        } else if (name.endsWith("Tech")) {
            this.tech();
        } else if (!name.endsWith("TechActivation")) {
            if (name.endsWith("Purchase")) {
                this.purchase(false);
            } else if (name.endsWith("Move")) {
                boolean nonCombat = name.endsWith("NonCombatMove");
                this.move(nonCombat, name);
                if (!nonCombat) {
                    ((TripleAFrame)this.m_ui).waitForMoveForumPoster(this.getPlayerID(), this.getPlayerBridge());
                }
            } else if (name.endsWith("Battle")) {
                this.battle();
            } else if (name.endsWith("Place")) {
                this.place(name.endsWith("BidPlace"));
            } else if (name.endsWith("Politics")) {
                this.politics(true);
            } else if (name.endsWith("EndTurn")) {
                this.endTurn();
                this.m_soundPlayedAlreadyCombatMove = false;
                this.m_soundPlayedAlreadyNonCombatMove = false;
                this.m_soundPlayedAlreadyPurchase = false;
                this.m_soundPlayedAlreadyTechnology = false;
                this.m_soundPlayedAlreadyBattle = false;
                this.m_soundPlayedAlreadyEndTurn = false;
                this.m_soundPlayedAlreadyPlacement = false;
            } else {
                badStep = true;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((TripleAFrame)TripleAPlayer.this.m_ui).getEditModeButtonModel().setEnabled(false);
                ((TripleAFrame)TripleAPlayer.this.m_ui).getEditModeButtonModel().removeActionListener(TripleAPlayer.this.m_editModeAction);
                ((TripleAFrame)TripleAPlayer.this.m_ui).setEditDelegate(null);
            }
        });
        if (badStep) {
            throw new IllegalArgumentException("Unrecognized step name:" + name);
        }
    }

    private void politics(boolean firstRun) {
        if (!this.getPlayerID().amNotDeadYet(this.getGameData())) {
            return;
        }
        if (!Properties.getUsePolitics(this.getGameData())) {
            return;
        }
        IPoliticsDelegate iPoliticsDelegate = (IPoliticsDelegate)this.getPlayerBridge().getRemote();
        PoliticalActionAttachment actionChoice = ((TripleAFrame)this.m_ui).getPoliticalActionChoice(this.getPlayerID(), firstRun, iPoliticsDelegate);
        if (actionChoice != null) {
            iPoliticsDelegate.attemptAction(actionChoice);
            this.politics(false);
        }
    }

    @Override
    public boolean acceptPoliticalAction(String acceptanceQuestion) {
        if (!this.getPlayerID().amNotDeadYet(this.getGameData())) {
            return true;
        }
        return ((TripleAFrame)this.m_ui).acceptPoliticalAction("To " + this.getPlayerID().getName() + ": " + acceptanceQuestion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tech() {
        TechRoll techRoll;
        PlayerID id = this.getPlayerID();
        this.getGameData().acquireReadLock();
        try {
            if (!TripleAPlayer.isTechDevelopment(this.getGameData())) {
                return;
            }
            int techCost = TechTracker.getTechCost(id);
            int money = id.getResources().getQuantity("PUs");
            if (money < techCost) {
                PlayerAttachment pa = PlayerAttachment.get(id);
                if (pa == null) {
                    return;
                }
                ArrayList<PlayerID> helpPay = pa.getHelpPayTechCost();
                if (helpPay == null || helpPay.isEmpty()) {
                    return;
                }
                for (PlayerID p : helpPay) {
                    money += p.getResources().getQuantity("PUs");
                }
                if (money < techCost) {
                    return;
                }
            }
        }
        finally {
            this.getGameData().releaseReadLock();
        }
        if (!this.m_soundPlayedAlreadyTechnology) {
            ClipPlayer.play("phase_technology", id.getName());
            this.m_soundPlayedAlreadyTechnology = true;
        }
        if ((techRoll = ((TripleAFrame)this.m_ui).getTechRolls(id)) != null) {
            ITechDelegate techDelegate = (ITechDelegate)this.getPlayerBridge().getRemote();
            TechResults techResults = techDelegate.rollTech(techRoll.getRolls(), techRoll.getTech(), techRoll.getNewTokens(), techRoll.getWhoPaysHowMuch());
            if (techResults.isError()) {
                ((TripleAFrame)this.m_ui).notifyError(techResults.getErrorString());
                this.tech();
            } else {
                ((TripleAFrame)this.m_ui).notifyTechResults(techResults);
            }
        }
    }

    private void move(boolean nonCombat, String stepName) {
        PlayerID id = this.getPlayerID();
        if (stepName.endsWith("AirborneCombatMove") ? !SpecialMoveDelegate.allowAirborne(id, this.getGameData()) : !this.hasUnitsThatCanMove(nonCombat)) {
            return;
        }
        if (nonCombat && !this.m_soundPlayedAlreadyNonCombatMove) {
            ClipPlayer.play("phase_move_noncombat", id.getName());
            this.m_soundPlayedAlreadyNonCombatMove = true;
        } else if (!nonCombat && !this.m_soundPlayedAlreadyCombatMove) {
            ClipPlayer.play("phase_move_combat", id.getName());
            this.m_soundPlayedAlreadyCombatMove = true;
        }
        MoveDescription moveDescription = ((TripleAFrame)this.m_ui).getMove(id, this.getPlayerBridge(), nonCombat, stepName);
        if (moveDescription == null) {
            if (nonCombat) {
                if (!this.canAirLand(true, id)) {
                    this.move(nonCombat, stepName);
                }
            } else if (this.canUnitsFight()) {
                this.move(nonCombat, stepName);
            }
            return;
        }
        IMoveDelegate moveDel = (IMoveDelegate)this.getPlayerBridge().getRemote();
        String error = moveDel.move(moveDescription.getUnits(), moveDescription.getRoute(), moveDescription.getTransportsThatCanBeLoaded(), moveDescription.getDependentUnits());
        if (error != null) {
            ((TripleAFrame)this.m_ui).notifyError(error);
        }
        this.move(nonCombat, stepName);
    }

    private boolean canAirLand(boolean movePhase, PlayerID player) {
        Collection<Territory> airCantLand = movePhase ? ((IMoveDelegate)this.getPlayerBridge().getRemote()).getTerritoriesWhereAirCantLand(player) : ((IAbstractPlaceDelegate)this.getPlayerBridge().getRemote()).getTerritoriesWhereAirCantLand();
        if (airCantLand.isEmpty()) {
            return true;
        }
        StringBuilder buf = new StringBuilder("Air in following territories cant land:");
        Iterator<Territory> iter = airCantLand.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next().getName());
            buf.append(" ");
        }
        return ((TripleAFrame)this.m_ui).getOKToLetAirDie(this.getPlayerID(), buf.toString(), movePhase);
    }

    private boolean canUnitsFight() {
        Collection<Territory> unitsCantFight = ((IMoveDelegate)this.getPlayerBridge().getRemote()).getTerritoriesWhereUnitsCantFight();
        if (unitsCantFight.isEmpty()) {
            return false;
        }
        StringBuilder buf = new StringBuilder("Units in the following territories will die:");
        Iterator<Territory> iter = unitsCantFight.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next().getName());
            buf.append(" ");
        }
        return !((TripleAFrame)this.m_ui).getOKToLetUnitsDie(this.getPlayerID(), buf.toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasUnitsThatCanMove(boolean nonCom) {
        PlayerID id = this.getPlayerID();
        CompositeMatchAnd<Unit> moveableUnitOwnedByMe = new CompositeMatchAnd<Unit>(new Match[0]);
        moveableUnitOwnedByMe.add(Matches.unitIsOwnedBy(id));
        moveableUnitOwnedByMe.add(Matches.UnitCanMove);
        if (!nonCom) {
            moveableUnitOwnedByMe.add(Matches.UnitCanNotMoveDuringCombatMove.invert());
        }
        this.getGameData().acquireReadLock();
        try {
            for (Territory item : this.getGameData().getMap().getTerritories()) {
                if (!item.getUnits().someMatch(moveableUnitOwnedByMe)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.getGameData().releaseReadLock();
        }
    }

    private void purchase(boolean bid) {
        IntegerMap<ProductionRule> prod;
        PlayerID id = this.getPlayerID();
        if (bid && !BidPurchaseDelegate.doesPlayerHaveBid(this.getGameData(), id)) {
            return;
        }
        if (this.getPlayerBridge().getStepName().endsWith("NoPUPurchase")) {
            return;
        }
        if (id.getProductionFrontier() == null || id.getProductionFrontier().getRules().isEmpty()) {
            return;
        }
        ArrayList<Territory> capitalsListOriginal = new ArrayList<Territory>(TerritoryAttachment.getAllCapitals(id, this.getGameData()));
        ArrayList<Territory> capitalsListOwned = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(id, this.getGameData()));
        PlayerAttachment pa = PlayerAttachment.get(id);
        if (!capitalsListOriginal.isEmpty() && capitalsListOwned.isEmpty() || pa != null && pa.getRetainCapitalProduceNumber() > capitalsListOwned.size()) {
            return;
        }
        if (!this.canWePurchaseOrRepair()) {
            return;
        }
        if (!bid && !this.m_soundPlayedAlreadyPurchase) {
            ClipPlayer.play("phase_purchase", id.getName());
            this.m_soundPlayedAlreadyPurchase = true;
        }
        String error = null;
        IPurchaseDelegate purchaseDel = (IPurchaseDelegate)this.getPlayerBridge().getRemote();
        if (id.getRepairFrontier() != null && id.getRepairFrontier().getRules() != null && !id.getRepairFrontier().getRules().isEmpty()) {
            GameData data;
            if (this.isSBRAffectsUnitProduction(this.getGameData())) {
                HashMap<Unit, IntegerMap<RepairRule>> repair;
                data = this.getGameData();
                ArrayList<Territory> bombedTerrs = new ArrayList<Territory>();
                for (Territory t : Match.getMatches(data.getMap().getTerritories(), Matches.territoryHasOwnedIsFactoryOrCanProduceUnits(data, id))) {
                    TerritoryAttachment ta = TerritoryAttachment.get(t);
                    if (ta.getProduction() <= ta.getUnitProduction()) continue;
                    bombedTerrs.add(t);
                }
                ArrayList<Unit> damagedUnits = new ArrayList<Unit>();
                CompositeMatchAnd myFactories = new CompositeMatchAnd(Matches.unitIsOwnedBy(id), Matches.UnitCanBeDamaged);
                for (Territory t : bombedTerrs) {
                    damagedUnits.addAll(Match.getMatches(t.getUnits().getUnits(), myFactories));
                }
                if (bombedTerrs.size() > 0 && damagedUnits.size() > 0 && (repair = ((TripleAFrame)this.m_ui).getRepair(id, bid)) != null && (error = (purchaseDel = (IPurchaseDelegate)this.getPlayerBridge().getRemote()).purchaseRepair(repair)) != null) {
                    ((TripleAFrame)this.m_ui).notifyError(error);
                    this.purchase(bid);
                }
            } else if (this.isDamageFromBombingDoneToUnitsInsteadOfTerritories(this.getGameData())) {
                HashMap<Unit, IntegerMap<RepairRule>> repair;
                data = this.getGameData();
                CompositeMatchAnd myDamaged = new CompositeMatchAnd(Matches.unitIsOwnedBy(id), Matches.UnitHasSomeUnitDamage());
                ArrayList<Unit> damagedUnits = new ArrayList<Unit>();
                for (Territory t : data.getMap().getTerritories()) {
                    damagedUnits.addAll(Match.getMatches(t.getUnits().getUnits(), myDamaged));
                }
                if (damagedUnits.size() > 0 && (repair = ((TripleAFrame)this.m_ui).getRepair(id, bid)) != null && (error = (purchaseDel = (IPurchaseDelegate)this.getPlayerBridge().getRemote()).purchaseRepair(repair)) != null) {
                    ((TripleAFrame)this.m_ui).notifyError(error);
                    this.purchase(bid);
                }
            }
        }
        if ((prod = ((TripleAFrame)this.m_ui).getProduction(id, bid)) == null) {
            return;
        }
        purchaseDel = (IPurchaseDelegate)this.getPlayerBridge().getRemote();
        error = purchaseDel.purchase(prod);
        if (error != null) {
            ((TripleAFrame)this.m_ui).notifyError(error);
            this.purchase(bid);
        }
    }

    private boolean canWePurchaseOrRepair() {
        PlayerID id = this.getPlayerID();
        if (id.getProductionFrontier() != null && id.getProductionFrontier().getRules() != null) {
            for (ProductionRule productionRule : id.getProductionFrontier().getRules()) {
                if (!id.getResources().has(productionRule.getCosts())) continue;
                return true;
            }
        }
        if (id.getRepairFrontier() != null && id.getRepairFrontier().getRules() != null) {
            for (RepairRule repairRule : id.getRepairFrontier().getRules()) {
                if (!id.getResources().has(repairRule.getCosts())) continue;
                return true;
            }
        }
        return false;
    }

    private void battle() {
        PlayerID id = this.getPlayerID();
        while (true) {
            IBattleDelegate battleDel;
            BattleListing battles;
            if ((battles = (battleDel = (IBattleDelegate)this.getPlayerBridge().getRemote()).getBattles()).isEmpty()) {
                IBattle battle = battleDel.getCurrentBattle();
                if (battle != null) {
                    System.err.println("Current battle exists but is not on pending list:  " + battle.toString());
                    battleDel.fightCurrentBattle();
                }
                return;
            }
            if (!this.m_soundPlayedAlreadyBattle) {
                ClipPlayer.play("phase_battle", id.getName());
                this.m_soundPlayedAlreadyBattle = true;
            }
            FightBattleDetails details = ((TripleAFrame)this.m_ui).getBattle(id, battles.getBattles(), battles.getStrategicRaids());
            if (this.getPlayerBridge().isGameOver()) {
                return;
            }
            String error = battleDel.fightBattle(details.getWhere(), details.isBombingRaid());
            if (error == null) continue;
            ((TripleAFrame)this.m_ui).notifyError(error);
        }
    }

    private void place(boolean bid) {
        PlayerID id = this.getPlayerID();
        IAbstractPlaceDelegate placeDel = (IAbstractPlaceDelegate)this.getPlayerBridge().getRemote();
        if (id.getUnits().size() == 0 && placeDel.getPlacementsMade() == 0) {
            return;
        }
        while (true) {
            PlaceData data;
            if (!this.m_soundPlayedAlreadyPlacement) {
                ClipPlayer.play("phase_placement", id.getName());
                this.m_soundPlayedAlreadyPlacement = true;
            }
            if ((data = ((TripleAFrame)this.m_ui).waitForPlace(id, bid, this.getPlayerBridge())) == null) {
                if (!this.canAirLand(false, id)) continue;
                return;
            }
            String error = placeDel.placeUnits(data.getUnits(), data.getAt());
            if (error == null) continue;
            ((TripleAFrame)this.m_ui).notifyError(error);
        }
    }

    private void endTurn() {
        if (!this.m_soundPlayedAlreadyEndTurn) {
            ClipPlayer.play("phase_end_turn", this.getPlayerID().getName());
            this.m_soundPlayedAlreadyEndTurn = true;
        }
        ((TripleAFrame)this.m_ui).waitForEndTurn(this.getPlayerID(), this.getPlayerBridge());
    }

    @Override
    public CasualtyDetails selectCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, CasualtyList defaultCasualties, GUID battleID) {
        return ((TripleAFrame)this.m_ui).getBattlePanel().getCasualties(selectFrom, dependents, count, message, dice, hit, defaultCasualties, battleID);
    }

    @Override
    public int[] selectFixedDice(int numDice, int hitAt, boolean hitOnlyIfEquals, String title, int diceSides) {
        return ((TripleAFrame)this.m_ui).selectFixedDice(numDice, hitAt, hitOnlyIfEquals, title, diceSides);
    }

    @Override
    public Territory selectBombardingTerritory(Unit unit, Territory unitTerritory, Collection<Territory> territories, boolean noneAvailable) {
        return ((TripleAFrame)this.m_ui).getBattlePanel().getBombardment(unit, unitTerritory, territories, noneAvailable);
    }

    @Override
    public boolean selectAttackSubs(Territory unitTerritory) {
        return ((TripleAFrame)this.m_ui).getBattlePanel().getAttackSubs(unitTerritory);
    }

    @Override
    public boolean selectAttackTransports(Territory unitTerritory) {
        return ((TripleAFrame)this.m_ui).getBattlePanel().getAttackTransports(unitTerritory);
    }

    @Override
    public boolean selectAttackUnits(Territory unitTerritory) {
        return ((TripleAFrame)this.m_ui).getBattlePanel().getAttackUnits(unitTerritory);
    }

    @Override
    public boolean selectShoreBombard(Territory unitTerritory) {
        return ((TripleAFrame)this.m_ui).getBattlePanel().getShoreBombard(unitTerritory);
    }

    @Override
    public boolean shouldBomberBomb(Territory territory) {
        return ((TripleAFrame)this.m_ui).getStrategicBombingRaid(territory);
    }

    @Override
    public Unit whatShouldBomberBomb(Territory territory, Collection<Unit> potentialTargets, Collection<Unit> bombers) {
        return ((TripleAFrame)this.m_ui).getStrategicBombingRaidTarget(territory, potentialTargets, bombers);
    }

    @Override
    public Territory whereShouldRocketsAttack(Collection<Territory> candidates, Territory from) {
        return ((TripleAFrame)this.m_ui).getRocketAttack(candidates, from);
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        return ((TripleAFrame)this.m_ui).moveFightersToCarrier(fightersThatCanBeMoved, from);
    }

    @Override
    public Territory selectTerritoryForAirToLand(Collection<Territory> candidates, Territory currentTerritory, String unitMessage) {
        return ((TripleAFrame)this.m_ui).selectTerritoryForAirToLand(candidates, currentTerritory, unitMessage);
    }

    @Override
    public boolean confirmMoveInFaceOfAA(Collection<Territory> aaFiringTerritories) {
        String question = "AA guns will fire in " + MyFormatter.territoriesToText(aaFiringTerritories, "and") + ", do you still want to move?";
        return ((TripleAFrame)this.m_ui).getOK(question);
    }

    @Override
    public boolean confirmMoveKamikaze() {
        String question = "Not all air units in destination territory can land, do you still want to move?";
        return ((TripleAFrame)this.m_ui).getOK("Not all air units in destination territory can land, do you still want to move?");
    }

    @Override
    public boolean confirmMoveHariKari() {
        String question = "All units in destination territory will automatically die, do you still want to move?";
        return ((TripleAFrame)this.m_ui).getOK("All units in destination territory will automatically die, do you still want to move?");
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Territory battleTerritory, Collection<Territory> possibleTerritories, String message) {
        return ((TripleAFrame)this.m_ui).getBattlePanel().getRetreat(battleID, message, possibleTerritories, submerge);
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        return ((TripleAFrame)this.m_ui).scrambleUnitsQuery(scrambleTo, possibleScramblers);
    }

    @Override
    public Collection<Unit> selectUnitsQuery(Territory current, Collection<Unit> possible, String message) {
        return ((TripleAFrame)this.m_ui).selectUnitsQuery(current, possible, message);
    }

    @Override
    public void confirmEnemyCasualties(GUID battleId, String message, PlayerID hitPlayer) {
        if (((TripleAFrame)this.m_ui).playing(hitPlayer)) {
            return;
        }
        if (!BattleDisplay.getShowEnemyCasualtyNotification()) {
            return;
        }
        ((TripleAFrame)this.m_ui).getBattlePanel().confirmCasualties(battleId, message);
    }

    @Override
    public void confirmOwnCasualties(GUID battleId, String message) {
        ((TripleAFrame)this.m_ui).getBattlePanel().confirmCasualties(battleId, message);
    }

    public final boolean isSBRAffectsUnitProduction(GameData data) {
        return Properties.getSBRAffectsUnitProduction(data);
    }

    public final boolean isDamageFromBombingDoneToUnitsInsteadOfTerritories(GameData data) {
        return Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data);
    }

    private static boolean isTechDevelopment(GameData data) {
        return Properties.getTechDevelopment(data);
    }

    @Override
    public HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>> selectKamikazeSuicideAttacks(HashMap<Territory, Collection<Unit>> possibleUnitsToAttack) {
        PlayerID id = this.getPlayerID();
        PlayerAttachment pa = PlayerAttachment.get(id);
        if (pa == null) {
            return null;
        }
        IntegerMap<Resource> resourcesAndAttackValues = pa.getSuicideAttackResources();
        if (resourcesAndAttackValues.size() <= 0) {
            return null;
        }
        IntegerMap<Resource> playerResourceCollection = id.getResources().getResourcesCopy();
        IntegerMap<Resource> attackTokens = new IntegerMap<Resource>();
        for (Resource possible : resourcesAndAttackValues.keySet()) {
            int amount = playerResourceCollection.getInt(possible);
            if (amount <= 0) continue;
            attackTokens.put(possible, amount);
        }
        if (attackTokens.size() <= 0) {
            return null;
        }
        HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>> rVal = new HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>>();
        for (Map.Entry entry : attackTokens.entrySet()) {
            Resource r = (Resource)entry.getKey();
            int max = entry.getValue();
            HashMap<Territory, IntegerMap<Unit>> selection = ((TripleAFrame)this.m_ui).selectKamikazeSuicideAttacks(possibleUnitsToAttack, r, max);
            for (Map.Entry<Territory, IntegerMap<Unit>> selectionEntry : selection.entrySet()) {
                Territory t = selectionEntry.getKey();
                HashMap<Unit, IntegerMap<Resource>> currentTerr = rVal.get(t);
                if (currentTerr == null) {
                    currentTerr = new HashMap();
                }
                for (Map.Entry<Unit, Integer> unitEntry : selectionEntry.getValue().entrySet()) {
                    Unit u = unitEntry.getKey();
                    IntegerMap<Resource> currentUnit = currentTerr.get(u);
                    if (currentUnit == null) {
                        currentUnit = new IntegerMap();
                    }
                    currentUnit.add(r, unitEntry.getValue());
                    currentTerr.put(u, currentUnit);
                }
                rVal.put(t, currentTerr);
            }
        }
        return rVal;
    }
}

