/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ai;

import games.strategy.common.player.AbstractBaseAI;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.net.GUID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.BasicPoliticalAI;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BidPurchaseDelegate;
import games.strategy.triplea.delegate.DelegateFinder;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.PoliticsDelegate;
import games.strategy.triplea.delegate.dataObjects.BattleListing;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IBattleDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAI
extends AbstractBaseAI
implements ITripleaPlayer,
IGamePlayer {
    private static final Logger s_logger = Logger.getLogger(AbstractAI.class.getName());

    public AbstractAI(String name, String type) {
        super(name, type);
    }

    protected abstract void purchase(boolean var1, int var2, IPurchaseDelegate var3, GameData var4, PlayerID var5);

    protected abstract void tech(ITechDelegate var1, GameData var2, PlayerID var3);

    protected abstract void move(boolean var1, IMoveDelegate var2, GameData var3, PlayerID var4);

    protected abstract void place(boolean var1, IAbstractPlaceDelegate var2, GameData var3, PlayerID var4);

    protected void battle(IBattleDelegate battleDelegate, GameData data, PlayerID player) {
        BattleListing listing;
        block0: while (!(listing = battleDelegate.getBattles()).getBattles().isEmpty() || !listing.getStrategicRaids().isEmpty()) {
            for (Territory current : listing.getStrategicRaids()) {
                String error = battleDelegate.fightBattle(current, true);
                if (error == null) continue;
                s_logger.fine(error);
            }
            Iterator<Territory> nonRaidBattles = listing.getBattles().iterator();
            while (true) {
                if (!nonRaidBattles.hasNext()) continue block0;
                Territory current = nonRaidBattles.next();
                String error = battleDelegate.fightBattle(current, false);
                if (error == null) continue;
                s_logger.fine(error);
            }
            break;
        }
        return;
    }

    @Override
    public Territory selectBombardingTerritory(Unit unit, Territory unitTerritory, Collection<Territory> territories, boolean noneAvailable) {
        return territories.iterator().next();
    }

    @Override
    public boolean selectAttackSubs(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectAttackTransports(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectAttackUnits(Territory unitTerritory) {
        return true;
    }

    @Override
    public boolean selectShoreBombard(Territory unitTerritory) {
        return true;
    }

    @Override
    public Territory whereShouldRocketsAttack(Collection<Territory> candidates, Territory from) {
        return candidates.iterator().next();
    }

    @Override
    public boolean confirmMoveKamikaze() {
        return false;
    }

    @Override
    public boolean confirmMoveHariKari() {
        return false;
    }

    @Override
    public boolean acceptPoliticalAction(String acceptanceQuestion) {
        if (!this.getPlayerID().amNotDeadYet(this.getGameData())) {
            return true;
        }
        return Math.random() < 0.5;
    }

    public void battleInfoMessage(String shortMessage, DiceRoll dice) {
    }

    @Override
    public void reportPoliticalMessage(String message) {
    }

    @Override
    public void confirmEnemyCasualties(GUID battleId, String message, PlayerID hitPlayer) {
    }

    public void retreatNotificationMessage(Collection<Unit> units) {
    }

    @Override
    public void reportError(String error) {
    }

    @Override
    public void reportMessage(String message, String title) {
    }

    @Override
    public void confirmOwnCasualties(GUID battleId, String message) {
        this.pause();
    }

    @Override
    public final void start(String name) {
        PlayerID id = this.getPlayerID();
        if (name.endsWith("Bid")) {
            String propertyName = id.getName() + " bid";
            int bidAmount = this.getGameData().getProperties().get(propertyName, 0);
            this.purchase(true, bidAmount, (IPurchaseDelegate)this.getPlayerBridge().getRemote(), this.getGameData(), id);
        } else if (name.endsWith("Tech")) {
            if (!Properties.getTechDevelopment(this.getGameData())) {
                return;
            }
            this.tech((ITechDelegate)this.getPlayerBridge().getRemote(), this.getGameData(), id);
        } else if (name.endsWith("Purchase")) {
            Resource PUs = this.getGameData().getResourceList().getResource("PUs");
            int leftToSpend = id.getResources().getQuantity(PUs);
            this.purchase(false, leftToSpend, (IPurchaseDelegate)this.getPlayerBridge().getRemote(), this.getGameData(), id);
        } else if (name.endsWith("Move")) {
            if (name.endsWith("AirborneCombatMove")) {
                return;
            }
            this.move(name.endsWith("NonCombatMove"), (IMoveDelegate)this.getPlayerBridge().getRemote(), this.getGameData(), id);
        } else if (name.endsWith("Battle")) {
            this.battle((IBattleDelegate)this.getPlayerBridge().getRemote(), this.getGameData(), id);
        } else if (name.endsWith("Politics")) {
            this.getPoliticalActions();
        } else if (name.endsWith("Place")) {
            this.place(name.indexOf("Bid") != -1, (IAbstractPlaceDelegate)this.getPlayerBridge().getRemote(), this.getGameData(), id);
        } else if (name.endsWith("EndTurn")) {
            // empty if block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getPoliticalActions() {
        GameData data = this.getGameData();
        PlayerID id = this.getPlayerID();
        if (!id.amNotDeadYet(data)) {
            return;
        }
        if (!Properties.getUsePolitics(data)) {
            return;
        }
        float numPlayers = data.getPlayerList().getPlayers().size();
        IPoliticsDelegate iPoliticsDelegate = (IPoliticsDelegate)this.getPlayerBridge().getRemote();
        PoliticsDelegate politicsDelegate = DelegateFinder.politicsDelegate(data);
        if (Math.random() < 0.5) {
            int MAX_WAR_ACTIONS_PER_TURN;
            List<PoliticalActionAttachment> actionChoicesTowardsWar = BasicPoliticalAI.getPoliticalActionsTowardsWar(id, politicsDelegate.getTestedConditions(), data);
            if (actionChoicesTowardsWar == null || actionChoicesTowardsWar.isEmpty()) return;
            Collections.shuffle(actionChoicesTowardsWar);
            int i = 0;
            double random = Math.random();
            int n = random < 0.5 ? 0 : (random < 0.9 ? 1 : (MAX_WAR_ACTIONS_PER_TURN = random < 0.99 ? 2 : (int)numPlayers / 2));
            if (MAX_WAR_ACTIONS_PER_TURN > 0 && (double)((float)Match.countMatches(data.getRelationshipTracker().getRelationships(id), Matches.RelationshipIsAtWar) / numPlayers) < 0.4) {
                MAX_WAR_ACTIONS_PER_TURN = Math.random() < 0.9 ? 0 : 1;
            }
            Iterator<PoliticalActionAttachment> actionWarIter = actionChoicesTowardsWar.iterator();
            while (actionWarIter.hasNext() && MAX_WAR_ACTIONS_PER_TURN > 0) {
                PoliticalActionAttachment action = actionWarIter.next();
                if (!Matches.PoliticalActionCanBeAttempted(politicsDelegate.getTestedConditions()).match(action)) continue;
                if (++i > MAX_WAR_ACTIONS_PER_TURN) return;
                iPoliticsDelegate.attemptAction(action);
            }
            return;
        } else {
            List<PoliticalActionAttachment> actionChoicesOther = BasicPoliticalAI.getPoliticalActionsOther(id, politicsDelegate.getTestedConditions(), data);
            if (actionChoicesOther == null || actionChoicesOther.isEmpty()) return;
            Collections.shuffle(actionChoicesOther);
            int i = 0;
            double random = Math.random();
            int MAX_OTHER_ACTIONS_PER_TURN = random < 0.3 ? 0 : (random < 0.6 ? 1 : (random < 0.9 ? 2 : (random < 0.99 ? 3 : (int)numPlayers)));
            Iterator<PoliticalActionAttachment> actionOtherIter = actionChoicesOther.iterator();
            while (actionOtherIter.hasNext() && MAX_OTHER_ACTIONS_PER_TURN > 0) {
                PoliticalActionAttachment action = actionOtherIter.next();
                if (!Matches.PoliticalActionCanBeAttempted(politicsDelegate.getTestedConditions()).match(action) || action.getCostPU() > 0 && action.getCostPU() > id.getResources().getQuantity("PUs")) continue;
                if (++i > MAX_OTHER_ACTIONS_PER_TURN) return;
                iPoliticsDelegate.attemptAction(action);
            }
        }
    }

    public final Class<ITripleaPlayer> getRemotePlayerType() {
        return ITripleaPlayer.class;
    }

    @Override
    public HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>> selectKamikazeSuicideAttacks(HashMap<Territory, Collection<Unit>> possibleUnitsToAttack) {
        PlayerID id = this.getPlayerID();
        PlayerAttachment pa = PlayerAttachment.get(id);
        if (pa == null) {
            return null;
        }
        IntegerMap<Resource> resourcesAndAttackValues = pa.getSuicideAttackResources();
        if (resourcesAndAttackValues.size() <= 0) {
            return null;
        }
        IntegerMap<Resource> playerResourceCollection = id.getResources().getResourcesCopy();
        IntegerMap<Resource> attackTokens = new IntegerMap<Resource>();
        for (Resource possible : resourcesAndAttackValues.keySet()) {
            int amount = playerResourceCollection.getInt(possible);
            if (amount <= 0) continue;
            attackTokens.put(possible, amount);
        }
        if (attackTokens.size() <= 0) {
            return null;
        }
        HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>> rVal = new HashMap<Territory, HashMap<Unit, IntegerMap<Resource>>>();
        for (Map.Entry<Territory, Collection<Unit>> entry : possibleUnitsToAttack.entrySet()) {
            if (attackTokens.size() <= 0) continue;
            Territory t = entry.getKey();
            ArrayList<Unit> targets = new ArrayList<Unit>(entry.getValue());
            Collections.shuffle(targets);
            for (Unit u : targets) {
                if (attackTokens.size() <= 0) continue;
                IntegerMap<Resource> rMap = new IntegerMap<Resource>();
                Resource r = (Resource)attackTokens.keySet().iterator().next();
                int num = Math.min(attackTokens.getInt(r), (UnitAttachment.get(u.getType()).getIsTwoHit() ? 2 : 1) * (Math.random() < 0.3 ? 1 : (Math.random() < 0.5 ? 2 : 3)));
                rMap.put(r, num);
                HashMap<Unit, IntegerMap<Resource>> attMap = rVal.get(t);
                if (attMap == null) {
                    attMap = new HashMap();
                }
                attMap.put(u, rMap);
                rVal.put(t, attMap);
                attackTokens.add(r, -num);
                if (attackTokens.getInt(r) > 0) continue;
                attackTokens.removeKey(r);
            }
        }
        return rVal;
    }

    public boolean canWePurchaseOrRepair(boolean bid) {
        PlayerID id = this.getPlayerID();
        if (bid && !BidPurchaseDelegate.doesPlayerHaveBid(this.getGameData(), id)) {
            return false;
        }
        if (this.getPlayerBridge().getStepName().endsWith("NoPUPurchase")) {
            return false;
        }
        if (id.getProductionFrontier() == null || id.getProductionFrontier().getRules().isEmpty()) {
            return false;
        }
        ArrayList<Territory> capitalsListOriginal = new ArrayList<Territory>(TerritoryAttachment.getAllCapitals(id, this.getGameData()));
        ArrayList<Territory> arrayList = new ArrayList<Territory>(TerritoryAttachment.getAllCurrentlyOwnedCapitals(id, this.getGameData()));
        PlayerAttachment pa = PlayerAttachment.get(id);
        if (!capitalsListOriginal.isEmpty() && arrayList.isEmpty() || pa != null && pa.getRetainCapitalProduceNumber() > arrayList.size()) {
            return false;
        }
        if (id.getProductionFrontier() != null && id.getProductionFrontier().getRules() != null) {
            for (ProductionRule productionRule : id.getProductionFrontier().getRules()) {
                if (!id.getResources().has(productionRule.getCosts())) continue;
                return true;
            }
        }
        if (id.getRepairFrontier() != null && id.getRepairFrontier().getRules() != null) {
            for (RepairRule repairRule : id.getRepairFrontier().getRules()) {
                if (!id.getResources().has(repairRule.getCosts())) continue;
                return true;
            }
        }
        return false;
    }
}

